"use strict";
(() => {
  // src/components/getData.tsx
  var { AutoLayout, Text, Input, useSyncedState } = figma.widget;
  function GetData({ handleClick }) {
    const [jsonData, setJsonData] = useSyncedState("jsonData", `{
    "header": "Grocery Todo List",
    "todos": [
      {"content": "Pasta", "State": true },
      {"content": "Rice", "State": false },
      {"content": "Noodles", "State": true }
    ]
   }`);
    function pushData() {
      if (!jsonData)
        return;
      let parsedData = JSON.parse(jsonData);
      console.log(parsedData);
      handleClick(parsedData);
    }
    return /* @__PURE__ */ figma.widget.h(
      AutoLayout,
      {
        name: "Checklist",
        effect: {
          type: "drop-shadow",
          color: "#0000001A",
          offset: {
            x: 0,
            y: 2
          },
          blur: 6
        },
        fill: "#FFF",
        cornerRadius: 8,
        direction: "vertical",
        spacing: 16,
        padding: {
          vertical: 24,
          horizontal: 24
        },
        width: 380,
        horizontalAlignItems: "center"
      },
      /* @__PURE__ */ figma.widget.h(AutoLayout, { name: "Header", overflow: "visible", direction: "vertical", spacing: 12, width: "fill-parent" }, /* @__PURE__ */ figma.widget.h(Text, { name: "header", fill: "#000", lineHeight: 24, fontFamily: "Inter", fontSize: 20, letterSpacing: -0.6, fontWeight: 700 }, "Enter JSON data")),
      /* @__PURE__ */ figma.widget.h(
        Input,
        {
          value: jsonData,
          placeholder: "Enter JSON Data",
          onTextEditEnd: (e) => setJsonData(e.characters),
          inputBehavior: "multiline",
          width: "fill-parent",
          height: 160,
          inputFrameProps: {
            fill: "#FAFAFA",
            stroke: "#D7D7D7",
            cornerRadius: 8,
            padding: 20
          }
        }
      ),
      /* @__PURE__ */ figma.widget.h(
        AutoLayout,
        {
          onClick: pushData,
          name: "Button",
          fill: "#18A0FB",
          cornerRadius: 4,
          overflow: "visible",
          spacing: 10,
          width: "fill-parent",
          horizontalAlignItems: "center",
          padding: {
            vertical: 8,
            horizontal: 0
          }
        },
        /* @__PURE__ */ figma.widget.h(Text, { name: "Render Widget", fill: "#FFF", lineHeight: 24, fontFamily: "Inter", fontSize: 14 }, "Render Widget")
      )
    );
  }
  var getData_default = GetData;

  // src/components/Header.tsx
  var { AutoLayout: AutoLayout2, Text: Text2 } = figma.widget;
  function Header({ children }) {
    return /* @__PURE__ */ figma.widget.h(
      AutoLayout2,
      {
        name: "Header",
        overflow: "visible",
        direction: "vertical",
        spacing: 12,
        padding: {
          vertical: 0,
          horizontal: 22
        },
        width: "fill-parent"
      },
      /* @__PURE__ */ figma.widget.h(Text2, { name: "header", fill: "#000", lineHeight: 24, fontFamily: "Inter", fontSize: 20, letterSpacing: -0.6, fontWeight: 700 }, children)
    );
  }
  var Header_default = Header;

  // src/components/Checkbox.tsx
  var { Frame, SVG, useSyncedState: useSyncedState2 } = figma.widget;
  function Checkbox({ checked }) {
    return checked ? /* @__PURE__ */ figma.widget.h(Frame, { name: "Checked", overflow: "visible", width: 32, height: 32 }, /* @__PURE__ */ figma.widget.h(Frame, { name: "cnt", x: 6, y: 6, fill: "#18A0FB", cornerRadius: 6, width: 20, height: 20 }, /* @__PURE__ */ figma.widget.h(
      Frame,
      {
        name: "Checked Icon",
        x: {
          type: "center",
          offset: 0
        },
        y: {
          type: "center",
          offset: 0
        },
        strokeWidth: 1.333,
        overflow: "visible",
        width: 16,
        height: 16
      },
      /* @__PURE__ */ figma.widget.h(
        SVG,
        {
          name: "ON",
          x: {
            type: "center",
            offset: 0
          },
          y: {
            type: "center",
            offset: 0
          },
          height: 8,
          width: 11,
          src: "<svg width='12' height='10' viewBox='0 0 12 10' fill='none' xmlns='http://www.w3.org/2000/svg'>\n<path fill-rule='evenodd' clip-rule='evenodd' d='M2.23531 3.43169L4.74512 5.94151L9.76473 0.921875L11.3334 2.49051L4.74512 9.07878L0.666687 5.00033L2.23531 3.43169Z' fill='white'/>\n</svg>\n"
        }
      )
    ))) : /* @__PURE__ */ figma.widget.h(Frame, { name: "unchecked", overflow: "visible", width: 32, height: 32 }, /* @__PURE__ */ figma.widget.h(Frame, { name: "Frame 624563", x: 6, y: 6, stroke: "#0006", cornerRadius: 6, strokeWidth: 0.833, width: 20, height: 20 }));
  }
  var Checkbox_default = Checkbox;

  // src/components/TodoRow.tsx
  var { AutoLayout: AutoLayout3, Text: Text3 } = figma.widget;
  function Row({ todo, handleClick }) {
    return /* @__PURE__ */ figma.widget.h(
      AutoLayout3,
      {
        name: "row",
        overflow: "visible",
        spacing: 8,
        verticalAlignItems: "center",
        width: "fill-parent",
        padding: {
          top: 0,
          right: 0,
          bottom: 0,
          left: 16
        },
        hoverStyle: {
          fill: "#F4F4F4"
        },
        onClick: () => handleClick(todo)
      },
      /* @__PURE__ */ figma.widget.h(Checkbox_default, { checked: todo.state }),
      /* @__PURE__ */ figma.widget.h(Text3, { name: "todo", fill: "#000", width: 320, lineHeight: 24, fontFamily: "Inter", fontSize: 14 }, todo.content)
    );
  }
  var TodoRow_default = Row;

  // src/components/TodoRowGroup.tsx
  var { AutoLayout: AutoLayout4 } = figma.widget;
  function TodoRowGroup({ data, onclick }) {
    return /* @__PURE__ */ figma.widget.h(
      AutoLayout4,
      {
        name: "Row Group",
        overflow: "visible",
        direction: "vertical",
        width: "fill-parent",
        spacing: 4,
        padding: {
          top: 0,
          right: 0,
          bottom: 0,
          left: 0
        }
      },
      data.map((e) => /* @__PURE__ */ figma.widget.h(TodoRow_default, { todo: e, key: e.content, handleClick: onclick }))
    );
  }
  var TodoRowGroup_default = TodoRowGroup;

  // src/code.tsx
  var { widget } = figma;
  var { Frame: Frame2, SVG: SVG2, Text: Text4, AutoLayout: AutoLayout5, Rectangle, useSyncedState: useSyncedState3 } = widget;
  console.log("new thing");
  function Widget() {
    const [todoData, setTodoData] = useSyncedState3("data", null);
    function handleClick(todo) {
      setTodoData((prev) => {
        let el = prev.todos.find((e) => e.content === todo.content);
        let index = prev.todos.indexOf(el);
        prev.todos[index].state = !prev.todos[index].state;
        return prev;
      });
    }
    if (!todoData) {
      return /* @__PURE__ */ figma.widget.h(getData_default, { handleClick: setTodoData });
    }
    return /* @__PURE__ */ figma.widget.h(
      AutoLayout5,
      {
        name: "Checklist",
        effect: {
          type: "drop-shadow",
          color: "#0000001A",
          offset: {
            x: 0,
            y: 2
          },
          blur: 6
        },
        fill: "#FFF",
        cornerRadius: 8,
        direction: "vertical",
        spacing: 16,
        width: 380,
        padding: {
          vertical: 24,
          horizontal: 0
        },
        horizontalAlignItems: "center"
      },
      /* @__PURE__ */ figma.widget.h(Header_default, null, todoData.header),
      /* @__PURE__ */ figma.widget.h(TodoRowGroup_default, { data: todoData.todos, onclick: handleClick })
    );
  }
  widget.register(Widget);
})();
