import GetData from "./components/getData";
import Header from "./components/Header";
import TodoGroup from "./components/TodoRowGroup";

const { widget } = figma;
const { Frame, SVG, Text, AutoLayout, Rectangle, useSyncedState } = widget;

console.log("new thing");

export type Todo = {
  content: string;
  state: boolean;
};

export type Data = {
  header: string;
  todos: Todo[];
};

function Widget() {
  const [todoData, setTodoData] = useSyncedState<Data | null>("data", null);

  function handleClick(todo: Todo) {
    setTodoData((prev) => {
      let el = prev!.todos.find((e) => e.content === todo.content);

      let index = prev!.todos.indexOf(el!);
      prev!.todos[index].state = !prev!.todos[index].state;
      return prev;
    });
  }

  if (!todoData) {
    return <GetData handleClick={setTodoData} />;
  }

  return (
    <AutoLayout
      name="Checklist"
      effect={{
        type: "drop-shadow",
        color: "#0000001A",
        offset: {
          x: 0,
          y: 2,
        },
        blur: 6,
      }}
      fill="#FFF"
      cornerRadius={8}
      direction="vertical"
      spacing={16}
      width={380}
      padding={{
        vertical: 24,
        horizontal: 0,
      }}
      horizontalAlignItems="center">
      <Header>{todoData.header}</Header>
      <TodoGroup data={todoData.todos} onclick={handleClick} />
    </AutoLayout>
  );
}

widget.register(Widget);
