const { Frame, SVG, useSyncedState } = figma.widget;

type props = {
  checked: boolean;
};

function Checkbox({ checked }: props) {
  return checked ? (
    <Frame name="Checked" overflow="visible" width={32} height={32}>
      <Frame name="cnt" x={6} y={6} fill="#18A0FB" cornerRadius={6} width={20} height={20}>
        <Frame
          name="Checked Icon"
          x={{
            type: "center",
            offset: 0,
          }}
          y={{
            type: "center",
            offset: 0,
          }}
          strokeWidth={1.333}
          overflow="visible"
          width={16}
          height={16}>
          <SVG
            name="ON"
            x={{
              type: "center",
              offset: 0,
            }}
            y={{
              type: "center",
              offset: 0,
            }}
            height={8}
            width={11}
            src="<svg width='12' height='10' viewBox='0 0 12 10' fill='none' xmlns='http://www.w3.org/2000/svg'>
<path fill-rule='evenodd' clip-rule='evenodd' d='M2.23531 3.43169L4.74512 5.94151L9.76473 0.921875L11.3334 2.49051L4.74512 9.07878L0.666687 5.00033L2.23531 3.43169Z' fill='white'/>
</svg>
"
          />
        </Frame>
      </Frame>
    </Frame>
  ) : (
    <Frame name="unchecked" overflow="visible" width={32} height={32}>
      <Frame name="Frame 624563" x={6} y={6} stroke="#0006" cornerRadius={6} strokeWidth={0.833} width={20} height={20} />
    </Frame>
  );
}

export default Checkbox;
