const { AutoLayout, Text } = figma.widget;

type props = {
  children: string;
};

function Header({ children }: props) {
  return (
    <AutoLayout
      name="Header"
      overflow="visible"
      direction="vertical"
      spacing={12}
      padding={{
        vertical: 0,
        horizontal: 22,
      }}
      width={"fill-parent"}>
      <Text name="header" fill="#000" lineHeight={24} fontFamily="Inter" fontSize={20} letterSpacing={-0.6} fontWeight={700}>
        {children}
      </Text>
    </AutoLayout>
  );
}

export default Header;
