import { Todo } from "../code";
import Checkbox from "./Checkbox";
const { AutoLayout, Text } = figma.widget;

type props = {
  todo: Todo;
  handleClick: (todo: Todo) => void;
};

function Row({ todo, handleClick }: props) {
  return (
    <AutoLayout
      name="row"
      overflow="visible"
      spacing={8}
      verticalAlignItems="center"
      width={"fill-parent"}
      padding={{
        top: 0,
        right: 0,
        bottom: 0,
        left: 16,
      }}
      hoverStyle={{
        fill: "#F4F4F4",
      }}
      onClick={() => handleClick(todo)}>
      <Checkbox checked={todo.state} />
      <Text name="todo" fill="#000" width={320} lineHeight={24} fontFamily="Inter" fontSize={14}>
        {todo.content}
      </Text>
    </AutoLayout>
  );
}

export default Row;
