import TodoRow from "./TodoRow";
import { Todo } from "../code";
const { AutoLayout } = figma.widget;

type props = {
  data: Todo[];
  onclick: (todo:Todo) => void;
};

function TodoRowGroup({ data, onclick }: props) {
  return (
    <AutoLayout
      name="Row Group"
      overflow="visible"
      direction="vertical"
      width={"fill-parent"}
      spacing={4}
      padding={{
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
      }}>
      {data.map((e) => (
        <TodoRow todo={e} key={e.content} handleClick={onclick} />
      ))}
    </AutoLayout>
  );
}

export default TodoRowGroup;
