import { Data } from "../code";
const { AutoLayout, Text, Input, useSyncedState } = figma.widget;

type props = {
  handleClick: (data: Data) => void;
};

function GetData({ handleClick }: props) {
  const [jsonData, setJsonData] = useSyncedState<string>("jsonData", `{
    "header": "Grocery Todo List",
    "todos": [
      {"content": "Pasta", "State": true },
      {"content": "Rice", "State": false },
      {"content": "Noodles", "State": true }
    ]
   }`);

  function pushData() {
    if (!jsonData) return;
    let parsedData: Data = JSON.parse(jsonData);
    console.log(parsedData);
    handleClick(parsedData);
  }

  return (
    <AutoLayout
      name="Checklist"
      effect={{
        type: "drop-shadow",
        color: "#0000001A",
        offset: {
          x: 0,
          y: 2,
        },
        blur: 6,
      }}
      fill="#FFF"
      cornerRadius={8}
      direction="vertical"
      spacing={16}
      padding={{
        vertical: 24,
        horizontal: 24,
      }}
      width={380}
      horizontalAlignItems="center">
      <AutoLayout name="Header" overflow="visible" direction="vertical" spacing={12} width="fill-parent">
        <Text name="header" fill="#000" lineHeight={24} fontFamily="Inter" fontSize={20} letterSpacing={-0.6} fontWeight={700}>
          Enter JSON data
        </Text>
      </AutoLayout>

      <Input
        value={jsonData}
        placeholder="Enter JSON Data"
        onTextEditEnd={(e) => setJsonData(e.characters)}
        inputBehavior="multiline"
        width={"fill-parent"}
        
        height={160}
        inputFrameProps={{
          fill: "#FAFAFA",
          stroke: "#D7D7D7",
          cornerRadius: 8,
          padding: 20,
        }}
      />
      <AutoLayout
        onClick={pushData}
        name="Button"
        fill="#18A0FB"
        cornerRadius={4}
        overflow="visible"
        spacing={10}
        width={"fill-parent"}
        horizontalAlignItems="center"
        padding={{
          vertical: 8,
          horizontal: 0,
        }}>
        <Text name="Render Widget" fill="#FFF" lineHeight={24} fontFamily="Inter" fontSize={14}>
          Render Widget
        </Text>
      </AutoLayout>
    </AutoLayout>
  );
}

export default GetData;
