const fs = require("fs");

let buffer = fs.readFileSync("./src/data.txt");
let data = buffer.toString();

let dataAry = data.split("\n");

let parsedData = [];

dataAry.forEach((e) => {
  // remove spaces
  if(e.trim().length === 0) return;
  
  let code = e.charCodeAt(0);
  if (code == 9 || code == 32) {
    e = e.trim();
    let payload = {
      type: "subtask",
      name: e,
      completed: false,
    };
    parsedData[parsedData.length - 1]["subTask"].push(payload);
  } else {
    e = e.trim();
    let payload = {
      type: "task",
      name: e,
      completed: false,
      subTask: [],
    };
    parsedData.push(payload);
  }
});

let result = { list: parsedData };
fs.writeFileSync("./src/data.json", JSON.stringify(result));
