(() => {
  // util/colorConverter.ts
  var namesRGB = ["r", "g", "b"];
  function figmaRGBToWebRGB(color) {
    const rgb = [];
    namesRGB.forEach((e, i) => {
      rgb[i] = Math.round(color[e] * 255);
    });
    if (color["a"] !== void 0)
      rgb[3] = Math.round(color["a"] * 100) / 100;
    return rgb;
  }
  function webRGBToFigmaRGB(color) {
    const rgb = {};
    namesRGB.forEach((e, i) => {
      rgb[e] = color[i] / 255;
    });
    if (color[3] !== void 0)
      rgb["a"] = color[3];
    return rgb;
  }
  function figmaRGBToHex(color) {
    let hex = "#";
    const rgb = figmaRGBToWebRGB(color);
    hex += ((1 << 24) + (rgb[0] << 16) + (rgb[1] << 8) + rgb[2]).toString(16).slice(1);
    if (rgb[3] !== void 0) {
      const a = Math.round(rgb[3] * 255).toString(16);
      if (a.length == 1) {
        hex += "0" + a;
      } else {
        if (a !== "ff")
          hex += a;
      }
    }
    return hex;
  }
  function hexToFigmaRGB(color) {
    let opacity = "";
    color = color.toLowerCase();
    if (color[0] === "#")
      color = color.slice(1);
    if (color.length === 3) {
      color = color.replace(/(.)(.)(.)?/g, "$1$1$2$2$3$3");
    } else if (color.length === 8) {
      const arr = color.match(/(.{6})(.{2})/);
      color = arr[1];
      opacity = arr[2];
    }
    const num = parseInt(color, 16);
    const rgb = [num >> 16, num >> 8 & 255, num & 255];
    if (opacity) {
      rgb.push(parseInt(opacity, 16) / 255);
      return webRGBToFigmaRGB(rgb);
    } else {
      return webRGBToFigmaRGB(rgb);
    }
  }

  // util/cloner.ts
  function clone(val) {
    const type = typeof val;
    if (type === "undefined" || type === "number" || type === "string" || type === "boolean" || type === "symbol" || val === null) {
      return val;
    } else if (type === "object") {
      if (val instanceof Array) {
        return val.map(clone);
      } else if (val instanceof Uint8Array) {
        return new Uint8Array(val);
      } else {
        const o = {};
        for (const key in val) {
          o[key] = clone(val[key]);
        }
        return o;
      }
    }
    throw "unknown";
  }

  // code.ts
  var colorMap = {
    textNode: [
      {
        light: "#000000",
        dark: "#E2E4E6"
      },
      {
        light: "#5A616F",
        dark: "#A8B0BD"
      },
      {
        light: "#6CBBFC",
        dark: "#479DFF"
      },
      {
        light: "#26A942",
        dark: "#4AC064"
      },
      {
        light: "#DE3535",
        dark: "#FF6B6B"
      },
      {
        light: "#FFFFFF",
        dark: "#E2E4E6"
      },
      {
        light: "#010101",
        dark: "#E2E4E6"
      }
    ],
    vectorNode: [
      {
        light: "#2C334D",
        dark: "#1B212B"
      },
      {
        light: "#383F57",
        dark: "#232B38"
      },
      {
        light: "#FFFFFF",
        dark: "#232B38"
      },
      {
        light: "#ECEFF3",
        dark: "#1B212B"
      },
      {
        light: "#0A73EB",
        dark: "#479DFF"
      },
      {
        light: "#5A616F",
        dark: "#A8B0BD"
      },
      {
        light: "#838692",
        dark: "#838692"
      },
      {
        light: "#EBF0F5",
        dark: "#3E4D63"
      },
      {
        light: "#D5DDE7",
        dark: "#3E4D63"
      },
      {
        light: "#F6F8FB",
        dark: "#2D3748"
      },
      {
        light: "#DFE6F2",
        dark: "#555B65"
      },
      {
        light: "#010101",
        dark: "#E2E4E6"
      },
      {
        light: "#231F20",
        dark: "#E2E4E6"
      },
      {
        light: "#26A942",
        dark: "#4AC064"
      },
      {
        light: "#F2FAF5",
        dark: "#25333A"
      },
      {
        light: "#FDF3F3",
        dark: "#FF6B6B"
      },
      {
        light: "#FFF6F0",
        dark: "#2E2F37"
      }
    ]
  };
  var selection = figma.currentPage.selection[0];
  function traverse(node) {
    if ("children" in node) {
      console.log(`Traversing ${node.type}`);
      for (const child of node.children) {
        traverse(child);
      }
    }
    toDark([node]);
  }
  traverse(selection);
  function getColor(color, type) {
    let nodeType = "";
    if (type === "TEXT") {
      nodeType = "textNode";
    } else {
      nodeType = "vectorNode";
    }
    if (color) {
      var hex = figmaRGBToHex(color);
      var obj = colorMap[nodeType].find((e) => e.light === hex.toUpperCase());
      if (!obj) {
        console.log(type, hex);
      }
      if (obj && "dark" in obj)
        return hexToFigmaRGB(obj.dark);
      return color;
    }
  }
  function toDark(ary) {
    ary.forEach((node) => {
      let fills = clone(node.fills);
      let strokes = clone(node.strokes);
      if (fills && fills.length && "color" in fills[0]) {
        let color = getColor(fills[0].color, node.type);
        Object.assign(fills[0].color, color);
        node.fills = fills;
      }
      if (strokes && strokes.length && "color" in strokes[0]) {
        console.log("stroking....");
        let color = getColor(strokes[0].color, node.type);
        Object.assign(strokes[0].color, color);
        node.strokes = strokes;
      }
    });
  }
  figma.closePlugin();
})();
