import { figmaRGBToHex, hexToFigmaRGB } from "./util/colorConverter";
import clone from "./util/cloner";

const colorMap = {
  textNode: [
    {
      light: "#000000",
      dark: "#E2E4E6",
    },
    {
      light: "#5A616F",
      dark: "#A8B0BD",
    },
    {
      light: "#6CBBFC",
      dark: "#479DFF",
    },
    {
      light: "#26A942",
      dark: "#4AC064",
    },

    {
      light: "#DE3535",
      dark: "#FF6B6B",
    },
    {
      light: "#FFFFFF",
      dark: "#E2E4E6",
    },
    {
      light: "#010101",
      dark: "#E2E4E6",
    },
  ],
  vectorNode: [
    {
      light: "#2C334D",
      dark: "#1B212B",
    },
    {
      light: "#383F57",
      dark: "#232B38",
    },
    {
      light: "#FFFFFF",
      dark: "#232B38",
    },
    {
      light: "#ECEFF3",
      dark: "#1B212B",
    },
    {
      light: "#0A73EB",
      dark: "#479DFF",
    },
    {
      light: "#5A616F",
      dark: "#A8B0BD",
    },
    {
      light: "#838692",
      dark: "#838692",
    },
    // {
    //   light: "#EBF0F5",
    //   dark: "#2D3748",
    // },
    {
      light: "#EBF0F5",
      dark: "#3E4D63",
    },
    {
      light: "#D5DDE7",
      dark: "#3E4D63",
    },
    {
      light: "#F6F8FB",
      dark: "#2D3748",
    },
    //Temp
    {
      light: "#DFE6F2",
      dark: "#555B65",
    },
    {
      light: "#010101",
      dark: "#E2E4E6",
    },
    {
      light: "#231F20",
      dark: "#E2E4E6",
    },
    //Green
    {
      light: "#26A942",
      dark: "#4AC064",
    },
    {
      light: "#F2FAF5",
      dark: "#25333A",
    },
    //RED
    {
      light: "#FDF3F3",
      dark: "#FF6B6B",
    },
    //ORANGE
    {
      light: "#FFF6F0",
      dark: "#2E2F37",
    },
  ],
};

const selection = figma.currentPage.selection[0];
traverse(selection);

function traverse(node: SceneNode) {
  if ("children" in node) {
    console.log(`Traversing ${node.type}`);
    for (const child of node.children) {
      traverse(child);
    }
  }
  toDark([node]);
}

function getColor(color, type: String) {
  let nodeType = "";
  if (type === "TEXT") {
    nodeType = "textNode";
  } else {
    nodeType = "vectorNode";
  }

  if (color) {
    var hex = figmaRGBToHex(color);
    var obj = colorMap[nodeType].find(
      (e: { light: string }) => e.light === hex.toUpperCase()
    );

    if (!obj) {
      console.log(type, hex);
    }

    if (obj && "dark" in obj) return hexToFigmaRGB(obj.dark);
    return color;
  }
}

function toDark(ary: any[]) {
  ary.forEach((node: { fills: any; strokes: any; type: String }) => {
    let fills = clone(node.fills);
    let strokes = clone(node.strokes);
    if (fills && fills.length && "color" in fills[0]) {
      let color = getColor(fills[0].color, node.type);
      Object.assign(fills[0].color, color);
      node.fills = fills;
    }
    if (strokes && strokes.length && "color" in strokes[0]) {
      console.log("stroking....");
      let color = getColor(strokes[0].color, node.type);
      Object.assign(strokes[0].color, color);
      node.strokes = strokes;
    }
  });
}

figma.closePlugin();
