const fs = require("fs");

let data = {
  manager: {
    mg1: {
      name: "Yod Agbaria",
      email: "yoda@zylker.com",
      mobile: "(776) 175-8638",
      avatar: "",
    },
    mg2: {
      name: "Stella Ramirez",
      email: "start@zylker.com",
      mobile: "(987) 6543210",
      avatar: "",
    },
  },
  agent: {
    ag1: {
      name: "Clark Wayne",
      email: "stellar@zylker.com",
      mobile: "(549) 578-0974",
      avatar: "",
    },
    ag2: {
      name: "Don Evans",
      email: "done@zylker.com",
      mobile: "(614) 874-0607",
      avatar: "",
    },
    ag3: {
      name: "Jo Yung",
      email: "joy@zylker.com",
      mobile: "(153) 877-4368",
      avatar: "",
    },
  },
  lightAgent: {
    ag1: {
      name: "Jordan Henderson",
      email: "henderson90@outlook.com",
      mobile: "(324) 417-2359",
      avatar: "",
    },
  },
  customer: {
    cs1: {
      name: "Sarah Paul",
      email: "ashlinpaul.w@gmail.com",
      mobile: "(+26) 669-7787",
      phone: "+17392038293",
      twitter: "Sarah4food",
      facebook: "Sarah Paul",
    },
    cs2: {
      name: "Carroll Arevalo",
      email: "carroll.arevalo@mail.com",
      mobile: "111-222-3333",
      phone: "+19876543210",
      twitter: "Carroll4u",
      facebook: "Arevalo",
    },
    cs3: {
      name: "Ibrahim Qasim",
      email: "ibrahimqasimz91@gmail.com",
      mobile: "(+91) 123-456-7899",
      phone: "+91 442-687-2650",
      twitter: "Qasirahim",
      facebook: "Ibrahim Qasim",
    },
  },
};

function genAgent() {
  for (let i = 1; i <= Object.keys(data.agent).length; i++) {
    let b64Data = fs
      .readFileSync(`./data/avatar/agent/ag${i}.png`)
      .toString("base64");
    data.agent[`ag${i}`].avatar = b64Data;
  }
}

function genManager() {
  for (let i = 1; i <= Object.keys(data.manager).length; i++) {
    let b64Data = fs
      .readFileSync(`./data/avatar/manager/mg${i}.png`)
      .toString("base64");
    data.manager[`mg${i}`].avatar = b64Data;
  }
}

function genLightAgent() {
  for (let i = 1; i <= Object.keys(data.lightAgent).length; i++) {
    let b64Data = fs
      .readFileSync(`./data/avatar/lightAgent/ag${i}.png`)
      .toString("base64");
    data.lightAgent[`ag${i}`].avatar = b64Data;
  }
}

function generatePersonaData() {
  genAgent();
  genManager();
  genLightAgent();
  console.log(data);
  fs.writeFileSync("./data/persona.json", JSON.stringify(data));
}

generatePersonaData();
