// @ts-ignore
import persona from "../data/persona.json";
import { getRandAgentAvatar, getRandData, updateText, updateImage, b642uint8, selectSimilarNodes } from "./util";
import { updateTheme } from "./theme";
import { handleParams } from "./parameters";

// This shows the HTML page in "ui.html".
figma.showUI(__html__, { width: 300, height: 480 });

figma.ui.onmessage = (msg) => {
  if (msg.type === "data") {
    // Avatar
    if (msg.module == "agent" && msg.item == "avatar") {
      for (const node of figma.currentPage.selection) {
        updateImage(node, getRandAgentAvatar());
      }
      return;
    }

    // Data
    selectSimilarNodes(figma.currentPage.selection[0], msg.all);

    for (const node of figma.currentPage.selection) {
      updateText(node, getRandData(msg));
    }
  }

  if (msg.type === "theme") {
    if (figma.currentPage.selection.length > 0) {
      // @ts-ignore
      updateTheme(figma.currentPage.selection, msg.theme);
    }
  }

  if (msg.type === "persona") {
    if (figma.currentPage.selection.length == 0) return;

    if (msg.dataType == "text") {
      for (const node of figma.currentPage.selection) {
        updateText(node, msg.value);
      }
    }

    if (msg.dataType == "avatar") {
      for (const node of figma.currentPage.selection) {
        updateImage(node, b642uint8(msg.value));
      }
    }
  }
};

// Sending persona data
figma.ui.postMessage({ type: "ui", data: persona });
