// @ts-nocheck
import data from "../data/data.json";
import persona from "../data/persona.json";

export function getRandData(msg): string {
  let module = msg.module;
  let item = msg.item;

  let selData: string[] = data[module][item];

  if (selData) {
    let randNum = rand(0, selData.length - 1);
    return selData[randNum];
  }
}

let loadedFont = [];

const isFontLoaded = ((str) => loadedFont.find((e) => e === str)) ? true : false;

export function updateText(node, char) {
  if (node.type === "TEXT") {
    if (node.hasMissingFont) return;

    if (loadedFont.length === 0 || !isFontLoaded(node.fontName)) {
      figma.loadFontAsync(node.fontName as FontName).then(() => (node.characters = char));
    } else {
      node.characters = char;
    }
  }
}

export function updateImage(node, uint8Data) {
  if (node.type === "RECTANGLE" || node.type === "ELLIPSE") {
    const paint: ImagePaint = {
      type: "IMAGE",
      scaleMode: "FILL",
      imageHash: figma.createImage(uint8Data).hash,
    };
    node.fills = [paint];
  }
}

export function getRandAgentAvatar() {
  let n = rand(1, Object.keys(persona.agent).length);
  let b64 = persona.agent[`ag${n}`]["avatar"];
  return b642uint8(b64);
}

// getRandomValue
function rand(min: number, max: number): number {
  return Math.floor(Math.random() * (max - min + 1) + min);
}

// converts base64 to unSignedInt8
export function b642uint8(b64) {
  let raw = atob(b64);
  // converting binary to unsigned integer8 array
  let rawLength = raw.length;
  let array = new Uint8Array(new ArrayBuffer(rawLength));

  for (let i = 0; i < rawLength; i++) {
    array[i] = raw.charCodeAt(i);
  }

  return array;
}

// converts base64 to binary
function atob(string) {
  const b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  const b64re = /^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/;
  string = String(string).replace(/[\t\n\f\r ]+/g, "");
  if (!b64re.test(string))
    throw new TypeError("Failed to execute 'atob' on 'Window': The string to be decoded is not correctly encoded.");

  string += "==".slice(2 - (string.length & 3));
  var bitmap,
    result = "",
    r1,
    r2,
    i = 0;
  for (; i < string.length; ) {
    bitmap =
      (b64.indexOf(string.charAt(i++)) << 18) |
      (b64.indexOf(string.charAt(i++)) << 12) |
      ((r1 = b64.indexOf(string.charAt(i++))) << 6) |
      (r2 = b64.indexOf(string.charAt(i++)));

    result +=
      r1 === 64
        ? String.fromCharCode((bitmap >> 16) & 255)
        : r2 === 64
        ? String.fromCharCode((bitmap >> 16) & 255, (bitmap >> 8) & 255)
        : String.fromCharCode((bitmap >> 16) & 255, (bitmap >> 8) & 255, bitmap & 255);
  }
  return result;
}

export function selectSimilarNodes(node, all: boolean): void {
  if (figma.currentPage.selection.length !== 1) return;
  if (figma.currentPage.selection[0].type !== "TEXT") return;
  if (node.parent.type === "PAGE") return;
  if (!all) return;

  let rootNode = node;

  // Update all text within root frame
  traverse(rootNode);
  let nodes;
  try {
    nodes = rootNode.findAll((e) => e.name == node.name);
  } catch (err) {
    figma.notify("Something went worng, could able to update on all the layers", {
      error: true,
      timeout: 3000,
    });
    return;
  }

  figma.currentPage.selection = nodes;

  function traverse(node) {
    if (node.parent.type === "PAGE") return;
    rootNode = node.parent;
    traverse(node.parent);
  }
}