"use strict";
(() => {
  // data.json
  var data_default = {
    textStyles: [
      {
        id: "S:7cf76191b3969e6b1bde357e5042dd0d70dc1911,",
        name: "PUVI - 9 Regular H(Auto L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 9
      },
      {
        id: "S:5c0ed1cd893610bf528a177b8fda8f3cc5a0b0fa,",
        name: "PUVI - 9 Semibold H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 9
      },
      {
        id: "S:c5403326bb6058d1c4170cbc52277a171224b704,",
        name: "PUVI - 10 Regular H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 10
      },
      {
        id: "S:f50d55744091a7fd6c28bcb9ee24bba5c7860553,",
        name: "PUVI - 10 Medium H(Auto) L(0%) - 10.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 10
      },
      {
        id: "S:15d8278112bfddf7dea15c7e9628518b9f2d5f0a,",
        name: "PUVI - 11 Caps Regular H(Auto) L(4%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 11
      },
      {
        id: "S:be16f1d8bf0353cbd76cd8eff6ab3d82477ea82c,",
        name: "PUVI - 11Px Light H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Light"
        },
        fontSize: 11
      },
      {
        id: "S:b70ec1e056c415ee1be38912d93b1d7d5e49b3e2,",
        name: "PUVI - 11 Regular H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 11
      },
      {
        id: "S:202b3bb44f93ec8f3eb14d03b2a923ab266ab13d,",
        name: "PUVI - 11 Medium H(Auto) L(0%) - 11.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 11
      },
      {
        id: "S:9695df6397026925cb558e8559de7bb737d2f59a,",
        name: "PUVI - 11 Caps Medium H(Auto) L(4%) - 11.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 11
      },
      {
        id: "S:5cdf5cb8d6a8ff0b7232a112fd582cc33e535a20,",
        name: "PUVI - 12 Regular H(Auto L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 12
      },
      {
        id: "S:64a7c4fe0af85988ccf38e120efe33d4586aefb7,",
        name: "PUVI - 12 Caps Medium H(Auto) L(4%) - 12.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 12
      },
      {
        id: "S:2191600732628381dea17913520d09438f4fa7fa,",
        name: "PUVI PARA - 12 Regular H(18) L(0%) - 12.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 12
      },
      {
        id: "S:70431b1f239606c28b3becd899d700ea42756f56,",
        name: "PUVI - 13 Regular H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 13
      },
      {
        id: "S:50fd1d35a4557529445060a596d82e86e9bbdafb,",
        name: "PUVI  PARA - 13 Regular H(22) L(0%) - 13.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 13
      },
      {
        id: "S:4811c83fc1d9505c1136933d64d74cbf48ea8ec2,",
        name: "PUVI - 13 Caps Medium H(Auto) L(4%) - 13.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 13
      },
      {
        id: "S:f6dce993b56d97d156f0b550fc694090f1ecb98d,",
        name: "PUVI - 13 Medium H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 13
      },
      {
        id: "S:48a4a6cb5ff3bc77573095ada8003c599ff0c15c,",
        name: "PUVI - 13 Caps Regular H(Auto) L(4%) - 13.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 13
      },
      {
        id: "S:dd9bcaa7671024f6c77e755022e9e0818f5f0f91,",
        name: "PUVI - 14 Regular H(Auto L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 14
      },
      {
        id: "S:592b365487bffea04d2cc7643e7dae2284deeccb,",
        name: "PUVI  PARA - 14 Regular H(20) L(0%) - 14.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 14
      },
      {
        id: "S:8653bc7b2cfdf2ab3f1628ec3c3ad56dc0847596,",
        name: "PUVI  PARA - 14 Medium H(20) L(0%) - 14.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 14
      },
      {
        id: "S:3ed95c21a4f0761770b1f06d69702df04c00c082,",
        name: "PUVI - 14 Medium H(20) L(0%) - 14.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 14
      },
      {
        id: "S:6ba58f026ef11cb4775f7441459c0155bd175d6e,",
        name: "PUVI - 14 Caps Medium H(Auto) L(4%) - 14.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 14
      },
      {
        id: "S:9fd4a352c15fd3bfb80107abe24264f390b88b29,",
        name: "PUVI - 15 Regular H(Auto L(0%) - 15.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 15
      },
      {
        id: "S:614470ce2a63dc36dbbdbbe1ed6ba2c7bb4025a1,",
        name: "PUVI  PARA - 15 Medium H(22) L(0%) - 15.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 15
      },
      {
        id: "S:befda06d4132163155bd68882ff0831ddfd4d03a,",
        name: "PUVI  PARA - 15 Regular H(22) L(0%) - 15.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 15
      },
      {
        id: "S:ad46dc05f592ed3b3cfa72b04fba85bd9e3a35f1,",
        name: "PUVI - 15 Medium H(Auto L(1%) - 15.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 15
      },
      {
        id: "S:682e5615450fd5fdc3397e2dc49e2a1fdb09299a,",
        name: "PUVI - 15 Semibold H(Auto L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 15
      },
      {
        id: "S:32aef1b77173589dd28a3c2e75f03ec8668a5813,",
        name: "PUVI - 16 Regular H(Auto) L(0%) - 16.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Regular"
        },
        fontSize: 16
      },
      {
        id: "S:ad57775b09b4cc0250119fe11b657f0d571ac293,",
        name: "PUVI - 16 Medium H(Auto) L(0%) - 16.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Medium"
        },
        fontSize: 16
      },
      {
        id: "S:1acde0a4a50e730040e544e69527d76c6ae988af,",
        name: "PUVI - 18 Semibold H(Auto) L(1%) - 18.0",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 18
      },
      {
        id: "S:c25990ef05719b7aa6a56b8c9915d0c1e11b4f43,",
        name: "PUVI - 24px Semibold H(Auto) L(0%)",
        fontName: {
          family: "Zoho Puvi",
          style: "Semibold"
        },
        fontSize: 24
      }
    ],
    paintStyles: [
      {
        id: "S:76c7d707adc03f43785e073477961fcdfec452fc,",
        name: "Grey/00\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 1,
              b: 1
            }
          }
        ]
      },
      {
        id: "S:c6bdde7f73f0e019ad6908b6869dad6820311b64,",
        name: "Grey / 10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9647058844566345,
              g: 0.9725490212440491,
              b: 0.9843137264251709
            }
          }
        ]
      },
      {
        id: "S:8d8e0959eed118be32419dabc022c97f716cd775,",
        name: "Grey / 15",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9215686321258545,
              g: 0.9411764740943909,
              b: 0.9607843160629272
            }
          }
        ]
      },
      {
        id: "S:e3414fd53248eeeffa254dafcb87bd5eac4f178d,",
        name: "Grey / 20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9058823585510254,
              g: 0.9254902005195618,
              b: 0.95686274766922
            }
          }
        ]
      },
      {
        id: "S:ed6d7cc6999b98d91b2742c4867b3b0b8680b9fd,",
        name: "Grey / 25",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9254902005195618,
              g: 0.9372549057006836,
              b: 0.9529411792755127
            }
          }
        ]
      },
      {
        id: "S:47190e9507be926b6eff877d27c525d70d3587c9,",
        name: "Grey/30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.8745098114013672,
              g: 0.9019607901573181,
              b: 0.9490196108818054
            }
          }
        ]
      },
      {
        id: "S:89d3f861e500c7364d6b58ca5697337300375e4a,",
        name: "Grey/35",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.8352941274642944,
              g: 0.8666666746139526,
              b: 0.9058823585510254
            }
          }
        ]
      },
      {
        id: "S:e4a25f4c009800818625ecdbea5de225f3e0034d,",
        name: "Grey/40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.7843137383460999,
              g: 0.7960784435272217,
              b: 0.8627451062202454
            }
          }
        ]
      },
      {
        id: "S:fbe16c50c642619dc508e8f5d1bad696cf7b608a,",
        name: "Grey / 50",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.6117647290229797,
              g: 0.6235294342041016,
              b: 0.6705882549285889
            }
          }
        ]
      },
      {
        id: "S:1bc4ddf88569aef91a54de7742abff12da39b12e,",
        name: "Grey / 55\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.47058823704719543,
              g: 0.5058823823928833,
              b: 0.5647059082984924
            }
          }
        ]
      },
      {
        id: "S:032173f44bb4bdb3ea57259366ca808391d26ed0,",
        name: "Grey / 60",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.3803921639919281,
              g: 0.4000000059604645,
              b: 0.47843137383461
            }
          }
        ]
      },
      {
        id: "S:ed4385f18a16544a7182dce5e2732ff6dd36985c,",
        name: "Grey/65\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.3529411852359772,
              g: 0.3803921639919281,
              b: 0.43529412150382996
            }
          }
        ]
      },
      {
        id: "S:2cbefe6a54ac3fdecab3da3c445d188a8bbc1d52,",
        name: "Grey / 70",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.29411765933036804,
              g: 0.3176470696926117,
              b: 0.40784314274787903
            }
          }
        ]
      },
      {
        id: "S:ad3d36c18a53c5cada276c8b48b6a01f692e0c2c,",
        name: "Grey / 75",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.2666666805744171,
              g: 0.29019609093666077,
              b: 0.3803921639919281
            }
          }
        ]
      },
      {
        id: "S:c25248fc63b787f5bb8ac34df704c89c7b1e841f,",
        name: "Grey / 80",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.21960784494876862,
              g: 0.24705882370471954,
              b: 0.34117648005485535
            }
          }
        ]
      },
      {
        id: "S:170ecb197fa35e785099b5888c874abd841c3d58,",
        name: "Grey / 85",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.1725490242242813,
              g: 0.20000000298023224,
              b: 0.3019607961177826
            }
          }
        ]
      },
      {
        id: "S:415bba436cff83effbc698543733f1f306280c10,",
        name: "Grey / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.13725490868091583,
              g: 0.16862745583057404,
              b: 0.21960784494876862
            }
          }
        ]
      },
      {
        id: "S:e99133fae612cb27cea64053e6486ff073cad9de,",
        name: "Grey/95",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.08627451211214066,
              g: 0.10588235408067703,
              b: 0.13725490868091583
            }
          }
        ]
      },
      {
        id: "S:a508f9738ff2f93ed9d84795e4975219cd4fb107,",
        name: "Grey/100\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0,
              g: 0,
              b: 0
            }
          }
        ]
      },
      {
        id: "S:d4dfe09e77a90db966c5fba248db15603b867d46,",
        name: "Red/10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9921568632125854,
              g: 0.9529411792755127,
              b: 0.9529411792755127
            }
          }
        ]
      },
      {
        id: "S:f98a584767518296513d2bac17ec44539436a4b1,",
        name: "Red/20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9882352948188782,
              g: 0.9215686321258545,
              b: 0.9215686321258545
            }
          }
        ]
      },
      {
        id: "S:7efc349cbdfa594246d232d4634a32d0c58f9b88,",
        name: "Red/30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9725490212440491,
              g: 0.843137264251709,
              b: 0.843137264251709
            }
          }
        ]
      },
      {
        id: "S:6f0ad7545c8e69adecc37e0f06b9038ab9239233,",
        name: "Red/40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9607843160629272,
              g: 0.7607843279838562,
              b: 0.7607843279838562
            }
          }
        ]
      },
      {
        id: "S:6f7043e624d39ed55d659414e508992fc6e99b14,",
        name: "Red/50",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.41960784792900085,
              b: 0.41960784792900085
            }
          }
        ]
      },
      {
        id: "S:6647cea3ec041cb45caf8eca6c30dd87f6df1053,",
        name: "Red / 60",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.886274516582489,
              g: 0.29411765933036804,
              b: 0.29411765933036804
            }
          }
        ]
      },
      {
        id: "S:6cd3fe5af0cb1cd09393182f83737edeeba67a24,",
        name: "Red/70\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.8705882430076599,
              g: 0.2078431397676468,
              b: 0.2078431397676468
            }
          }
        ]
      },
      {
        id: "S:6b36eb95aa522677a789aef453ae0fcff81337e8,",
        name: "Red / 80",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.800000011920929,
              g: 0.1882352977991104,
              b: 0.1764705926179886
            }
          }
        ]
      },
      {
        id: "S:1ca466d20a7f4b859206a00958f22548233ec440,",
        name: "Red / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.7056000232696533,
              g: 0.14517730474472046,
              b: 0.13439995050430298
            }
          }
        ]
      },
      {
        id: "S:154504270fe98428d840ed6042ca3eb1bff99e15,",
        name: "Red / 100",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.6705882549285889,
              g: 0.10196078568696976,
              b: 0.0941176488995552
            }
          }
        ]
      },
      {
        id: "S:4b1131a8fc7ffe6ea9a310747da40ad3cff787e9,",
        name: "Green/10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9490196108818054,
              g: 0.9803921580314636,
              b: 0.9607843160629272
            }
          }
        ]
      },
      {
        id: "S:08e61031523f404473ebcbbb37e2a95cc0085dbd,",
        name: "Green/20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9333333373069763,
              g: 0.9725490212440491,
              b: 0.9411764740943909
            }
          }
        ]
      },
      {
        id: "S:da3baf583eddcf9124bee627d8df4166f9242100,",
        name: "Green/30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.8313725590705872,
              g: 0.9333333373069763,
              b: 0.8509804010391235
            }
          }
        ]
      },
      {
        id: "S:c1630d5e737b9780217b134931cbab1a02fd27ca,",
        name: "Green/40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.7450980544090271,
              g: 0.8980392217636108,
              b: 0.7764706015586853
            }
          }
        ]
      },
      {
        id: "S:ca478f7c4580011e95f0f2b9b2b99d486fbad9fd,",
        name: "Green/70",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.29019609093666077,
              g: 0.7529411911964417,
              b: 0.3921568691730499
            }
          }
        ]
      },
      {
        id: "S:c8ef2d95d3bcc5fe082628caa7976a70966eccae,",
        name: "Green/80\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.14901961386203766,
              g: 0.6627451181411743,
              b: 0.25882354378700256
            }
          }
        ]
      },
      {
        id: "S:38dcae1b3756ad669db3172309975f992db8945f,",
        name: "Green / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.10588235408067703,
              g: 0.5490196347236633,
              b: 0.2078431397676468
            }
          }
        ]
      },
      {
        id: "S:4cb5dfbd28636fff6d574358428cc58e81011d1d,",
        name: "Green / 100",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.054901961237192154,
              g: 0.4588235318660736,
              b: 0.14901961386203766
            }
          }
        ]
      },
      {
        id: "S:7cd320982c81c09fb3cdefadb8eb9f791040d469,",
        name: "Blue / 10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9411764740943909,
              g: 0.9686274528503418,
              b: 0.9960784316062927
            }
          }
        ]
      },
      {
        id: "S:7f0808248e706c5a7c086a71c0cb27fbb8011a45,",
        name: "Blue/15",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9058823585510254,
              g: 0.9450980424880981,
              b: 0.9921568632125854
            }
          }
        ]
      },
      {
        id: "S:28bbe4f3dc0594fe15fed2d0c85b331662cbcf77,",
        name: "Blue / 20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.8352941274642944,
              g: 0.9176470637321472,
              b: 0.9882352948188782
            }
          }
        ]
      },
      {
        id: "S:0e21d00bc702f7f5591910ce1b6946a73d82d0b1,",
        name: "Blue / 30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.7439000010490417,
              g: 0.8573900461196899,
              b: 0.9961000084877014
            }
          }
        ]
      },
      {
        id: "S:b3a0ce3b98b9389491dacba07b879c9433c1bfec,",
        name: "Blue / 40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.615686297416687,
              g: 0.7803921699523926,
              b: 0.9686274528503418
            }
          }
        ]
      },
      {
        id: "S:216cf3729e55ed18152245c315970496fbc5f097,",
        name: "Blue/45",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.5098039507865906,
              g: 0.7490196228027344,
              b: 0.9607843160629272
            }
          }
        ]
      },
      {
        id: "S:1871fda7170a8b39984c27da553923f5d0d42fe6,",
        name: "Blue/50",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.42380207777023315,
              g: 0.7329267263412476,
              b: 0.987500011920929
            }
          }
        ]
      },
      {
        id: "S:e392d0859c1f6d8d93a0428e212d7ac4b12c4f7b,",
        name: "Blue/55",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.42352941632270813,
              g: 0.6705882549285889,
              b: 0.9529411792755127
            }
          }
        ]
      },
      {
        id: "S:a3192cf2842d91569606833c8afca2a447ede337,",
        name: "Blue / 60",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.27843138575553894,
              g: 0.615686297416687,
              b: 1
            }
          }
        ]
      },
      {
        id: "S:389fe4520e5ba42d8858694c2a97d8c41491e20f,",
        name: "Blue / 70",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.13999998569488525,
              g: 0.41233357787132263,
              b: 1
            }
          }
        ]
      },
      {
        id: "S:63304d872382381d35e80e0aed0c587c8f14c406,",
        name: "Blue / 75",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.13725490868091583,
              g: 0.5058823823928833,
              b: 0.929411768913269
            }
          }
        ]
      },
      {
        id: "S:d2be57a4323e702dc5ed8d3ebd886a2e2a243b2a,",
        name: "Blue/80\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.03921568766236305,
              g: 0.45098039507865906,
              b: 0.9215686321258545
            }
          }
        ]
      },
      {
        id: "S:8cd998c981eb315d04025c8f759e0898ec8858bf,",
        name: "Blue / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.062745101749897,
              g: 0.3960784375667572,
              b: 0.800000011920929
            }
          }
        ]
      },
      {
        id: "S:1e9d29c34eb7ca20ca7a65f68580384b8087321e,",
        name: "Blue / 100",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0,
              g: 0.32549020648002625,
              b: 0.7215686440467834
            }
          }
        ]
      },
      {
        id: "S:7dde294f2a506e0ec056e8f01b84a2437816a158,",
        name: "Orange/10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.9647058844566345,
              b: 0.9411764740943909
            }
          }
        ]
      },
      {
        id: "S:f169dcf7cefa48b9c872a15bf8891fbe0cdd3c30,",
        name: "Orange/20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.9450980424880981,
              b: 0.9019607901573181
            }
          }
        ]
      },
      {
        id: "S:cbbd7ba00b3c58445df4f881285a917fc967bad6,",
        name: "Orange/30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.886274516582489,
              b: 0.800000011920929
            }
          }
        ]
      },
      {
        id: "S:0c478b91c794b9e09251d45645b8e22a9a795f16,",
        name: "Orange/40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.8313725590705872,
              b: 0.7019608020782471
            }
          }
        ]
      },
      {
        id: "S:b0abd1b06e0253810f87550a184d1ec22e154d3d,",
        name: "Orange/60",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9647058844566345,
              g: 0.6431372761726379,
              b: 0.3490196168422699
            }
          }
        ]
      },
      {
        id: "S:e31968ffb3f6ab6faca3682818834e614ad4ef48,",
        name: "Orange / 70",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9725490212440491,
              g: 0.5333333611488342,
              b: 0.14509804546833038
            }
          }
        ]
      },
      {
        id: "S:cf6d359d717ef7be8471bfda6a74548780a3a116,",
        name: "Orange/80\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 1,
              g: 0.43529412150382996,
              b: 0
            }
          }
        ]
      },
      {
        id: "S:0dabd01cb76f9e9bc8d6ee838578cbd0fc03fe01,",
        name: "Orange / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.800000011920929,
              g: 0.3607843220233917,
              b: 0
            }
          }
        ]
      },
      {
        id: "S:829440377b4ef09930aa6807399700804cd760e8,",
        name: "Amber/10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9960784316062927,
              g: 0.9803921580314636,
              b: 0.95686274766922
            }
          }
        ]
      },
      {
        id: "S:493c065e3c0594cc024f2c05cb005e5e40a185f5,",
        name: "Amber/20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9960784316062927,
              g: 0.9686274528503418,
              b: 0.9254902005195618
            }
          }
        ]
      },
      {
        id: "S:cb0058921119b42774d27a75e87fb7bd7d969140,",
        name: "Amber/30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9882352948188782,
              g: 0.8901960849761963,
              b: 0.7411764860153198
            }
          }
        ]
      },
      {
        id: "S:d72e12556963188c6573c69faf6bcddda6e240f9,",
        name: "Amber / 40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9607843160629272,
              g: 0.8235294222831726,
              b: 0.6392157077789307
            }
          }
        ]
      },
      {
        id: "S:42c928e6afa849fd15f2490481edc6a3b25433f6,",
        name: "Amber / 50\u2009\u2009\u2009\u2009\u2009\u{1F130}",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9647058844566345,
              g: 0.6901960968971252,
              b: 0.2549019753932953
            }
          }
        ]
      },
      {
        id: "S:a47a43b10abcdb58746ad4b0b5659975fad04199,",
        name: "Amber / 60",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9372549057006836,
              g: 0.545098066329956,
              b: 0
            }
          }
        ]
      },
      {
        id: "S:00488f14bba622bfd090a02c2ca2bf0373e9dd0c,",
        name: "Amber / 70",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.7607843279838562,
              g: 0.5254902243614197,
              b: 0.12156862765550613
            }
          }
        ]
      },
      {
        id: "S:91cdaa2bb1f229d41cc0b5aa928d8bc6dd160b37,",
        name: "Yellow/10",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9960784316062927,
              g: 0.9882352948188782,
              b: 0.9529411792755127
            }
          }
        ]
      },
      {
        id: "S:224ecb1c060b2b3e734184a65a2cecb423ad93c5,",
        name: "Yellow/15",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9960784316062927,
              g: 0.9803921580314636,
              b: 0.9098039269447327
            }
          }
        ]
      },
      {
        id: "S:c3fe2cbb4802db641e6d162bfd6cbe097d38fbf6,",
        name: "Yellow / 20",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9960784316062927,
              g: 1,
              b: 0.8666666746139526
            }
          }
        ]
      },
      {
        id: "S:5f694a82e8cd65606dcb0aec3da5dbfdb22f57d1,",
        name: "Yellow / 30",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9254902005195618,
              g: 0.9254902005195618,
              b: 0.7764706015586853
            }
          }
        ]
      },
      {
        id: "S:dd0160e1d88bd9af3d127e717dda6dffb8973eb0,",
        name: "Yellow / 35",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9725490212440491,
              g: 0.9176470637321472,
              b: 0.6823529601097107
            }
          }
        ]
      },
      {
        id: "S:2c50dc2d418939bc834f94b545531600c9e47921,",
        name: "Yellow / 40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.9764705896377563,
              g: 0.8666666746139526,
              b: 0.29411765933036804
            }
          }
        ]
      },
      {
        id: "S:d171b25034bfc913746bcb79aebe05b2d891b9fc,",
        name: "Yellow / 100",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 1,
            blendMode: "NORMAL",
            color: {
              r: 0.30980393290519714,
              g: 0.23137255012989044,
              b: 0.04313725605607033
            }
          }
        ]
      },
      {
        id: "S:ab9fd602d5bc04e2ccfb53a64078ed83fce75612,",
        name: "Overlay/40",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 0.4000000059604645,
            blendMode: "NORMAL",
            color: {
              r: 0.11764705926179886,
              g: 0.14901961386203766,
              b: 0.20000000298023224
            }
          }
        ]
      },
      {
        id: "S:49283c27069eb097dd5eed025bf90faebced1514,",
        name: "Overlay/45",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 0.44999998807907104,
            blendMode: "NORMAL",
            color: {
              r: 0,
              g: 0,
              b: 0
            }
          }
        ]
      },
      {
        id: "S:6b6d9947a6df492cb539083a6492003ccc70165f,",
        name: "Overlay / 90",
        paints: [
          {
            type: "SOLID",
            visible: true,
            opacity: 0.9399999976158142,
            blendMode: "NORMAL",
            color: {
              r: 0.11764705926179886,
              g: 0.14901961386203766,
              b: 0.20000000298023224
            }
          }
        ]
      }
    ],
    components: [
      { key: "75646e93629d19196c2daec145620ea0b4d8d9a5", name: "Contact" },
      { key: "63845072831fa38635a9e0f3f6084366d68240c1", name: "Avatar" },
      { key: "6b0716f14621ef2c2642c874eb96ea19194adfca", name: "Button" },
      { key: "dc7a53a2f1333242165c475005ffa22402e2f462", name: "CheckBox" },
      { key: "1b350b566532a7f8f823409f7141e6ee76a32319", name: "Switch" },
      { key: "8d50e06eb9c86c8044c563d60c78c4950ee23e58", name: "Accordion" },
      { key: "12c98ed19c6987685d31757eaa3ebb628395bc03", name: "Breadcrumbs" },
      { key: "c8e28ddaefcf6017b9c23b85a717482954809afc", name: "Separator" },
      { key: "c0d4540b7e21f69e67f4f5695005d70cfd804722", name: "Ribbon" },
      { key: "082a63cc22504e94e87d4c054863bb70a55d39ec", name: "Labels" },
      { key: "50423f405ed77e67b8dc6e5fa69884b0914ab6c4", name: "Chips" },
      { key: "fca0ee27d048223625af40fed690ddf3cb9724a0", name: "Topband" },
      { key: "587400cab831061bb3640cb35956984b661c8e41", name: "Radio Button" },
      { key: "b137b1775bee7811ca58146456aef9f7c6433514", name: "Tooltip" },
      { key: "5c9b34ded1db32b604ef3e7a181181c7130acbc7", name: "Input" },
      { key: "6f2573c13d7cf49a924b06d12a946231cb088f20", name: "Input: Ticket Properties" },
      { key: "526d4693db00484d66a3985b7257468c00a83044", name: "LHS: Module" },
      { key: "7b60171e486220add34d1917ccc1cd4fe4101fa2", name: "LHS: Header" },
      { key: "065953bf55be753887d7bb73545de4ff31ee8489", name: "LHS: List Item" },
      { key: "774cf1aa4369be8cdb28f32b0d5d6002fd1b4700", name: "LHS: Collapse" },
      { key: "96872e8b47497a779a5d1ebcc59327ef0c4727b7", name: "LHS Filter: Fields" },
      { key: "93a62bfd0887ca05a6a5580752904c03f89f0ff4", name: "Tertiary Band" },
      { key: "003980e9178c3aad76def135c9549fbc048a8f29", name: "Criteria" },
      { key: "114badec1e0ecbe021702e7f40e7356430c3ae6f", name: "List: Ticket" },
      { key: "2ae31c8aff1ee23de39cdc063c47c045a2fdc594", name: "List: Activites" },
      { key: "2028f9a9c07c8cf568937d7dfb64d99c75c8635e", name: "Lists: Contact" },
      { key: "40d37d3cf9e5beb4df61b2757e9cf1e8ddb93e10", name: "ibar" },
      { key: "e809b9d1484bfabc307abce40fb28aca0b986e09", name: "Top Band_2" },
      { key: "8d5d83d8fba11883322c5591cb73da3b393daa03", name: "Alert" },
      { key: "3355b28bce6ff9e873ab50eb31f328c10353310c", name: "Rich Text Band" },
      { key: "6916104235afe9ce11e4064fb3536ad58e1fef78", name: "Rich Text Editor" },
      { key: "a279748a04dd9f60d9f893352a5cdeba76f4928d", name: "Menu" },
      { key: "48e24efd12fa1c85ec9d6fa0a6ba1848453847d4", name: "Notification" },
      { key: "e4185ddf5d3236ec2810ae142f527ab08a64649e", name: "Secondary Band" },
      { key: "255748e6cc2fe3b200b56d93947ca64ad4a53a20", name: "RHS: Header" },
      { key: "1ff5475fb56a2b11ebdd9b7de5cee59436175c90", name: "Calendar" },
      { key: "30182b44478682de333955ee9376083b24b2a999", name: "Ticket Thread" },
      { key: "69dea3b5ea474c6733bf415534f4b6b805bae63d", name: "Kanban Ticket Card" },
      { key: "019d43fb5cccca4ea46c83b4cd4ea6f3e355ab8d", name: "Contact Card" },
      { key: "e4185ddf5d3236ec2810ae142f527ab08a64649e", name: "Secondary Band" },
      { key: "38800390eebf6bdbb850ad9946df9a58422b0906", name: "Status" },
      { key: "50f0e0ae642201ac32ba153d14e89ce3967f394b", name: "thread" }
    ]
  };

  // code.ts
  var lintData = {
    nonStdText: [],
    otherLibText: [],
    localText: [],
    nonStdBg: [],
    otherLibBg: [],
    localBg: [],
    nonStdStroke: [],
    otherLibStroke: [],
    localStroke: [],
    otherLibComponent: []
  };
  figma.ui.onmessage = (message) => {
    if (message.type !== "LINT")
      return;
    lintData = {
      nonStdText: [],
      otherLibText: [],
      localText: [],
      nonStdBg: [],
      otherLibBg: [],
      localBg: [],
      nonStdStroke: [],
      otherLibStroke: [],
      localStroke: [],
      otherLibComponent: []
    };
    let currentSelection = figma.currentPage.selection;
    if (currentSelection.length === 0) {
      figma.ui.postMessage({ type: "NO_SELECTION" });
    } else {
      lintNodes(currentSelection);
      figma.ui.postMessage({ type: "DATA", data: lintData });
    }
  };
  function clone(val) {
    return JSON.parse(JSON.stringify(val));
  }
  function lint(node) {
    var _a, _b;
    function isSameId(id1, id2) {
      let firstId = id1.split(",")[0];
      let secondId = id2.split(",")[0];
      return firstId === secondId ? true : false;
    }
    if (node.type === "INSTANCE") {
      let key = (_a = node.mainComponent) == null ? void 0 : _a.key;
      let parentComponent = (_b = node.mainComponent) == null ? void 0 : _b.parent;
      if (parentComponent && parentComponent.type === "COMPONENT_SET") {
        key = parentComponent.key;
      }
      let componentKey = data_default.components.find((e) => isSameId(e.key, key));
      if (!componentKey) {
        lintData.otherLibComponent.push({ name: node.name, id: node.id, type: node.type });
        return;
      } else
        return;
    }
    typeCheck:
      if (node.type === "TEXT") {
        if (node.textStyleId) {
          let textStyleId = node.textStyleId;
          let localTextStyle = figma.getLocalTextStyles();
          let localStyle = localTextStyle.find((e) => isSameId(e.id, textStyleId));
          if (localStyle) {
            lintData.localText.push({ name: node.name, id: node.id, type: node.type });
            break typeCheck;
          }
          let style = data_default.textStyles.find((e) => isSameId(e.id, textStyleId));
          if (!style)
            lintData.otherLibText.push({ name: node.name, id: node.id, type: node.type });
        } else {
          let fontName = node.fontName;
          let fontSize = node.fontSize;
          let fontWeight = node.fontWeight;
          let style = data_default.textStyles.find((e) => {
            if (e.fontSize === fontSize && e.fontName.family === fontName.family && e.fontName.style === fontName.style)
              return true;
          });
          if (!style)
            lintData.nonStdText.push({ name: node.name, id: node.id, type: node.type });
        }
      }
    fillCheck:
      if ("fills" in node) {
        let fills = clone(node.fills);
        if (fills.length === 0)
          break fillCheck;
        if (fills.length > 1) {
          lintData.nonStdBg.push({ name: node.name, id: node.id, type: node.type });
          break fillCheck;
        }
        if (node.fillStyleId) {
          let fillStyleId = node.fillStyleId;
          let localPaintStyle = figma.getLocalPaintStyles();
          let localStyle = localPaintStyle.find((e) => isSameId(e.id, fillStyleId));
          if (localStyle) {
            lintData.localBg.push({ name: node.name, id: node.id, type: node.type });
            break fillCheck;
          }
          let style = data_default.paintStyles.find((e) => isSameId(e.id, fillStyleId));
          if (!style)
            lintData.otherLibBg.push({ name: node.name, id: node.id, type: node.type });
        } else {
          let { color, opacity, type } = fills[0];
          let style = data_default.paintStyles.find((e) => {
            if (e.paints[0].opacity === opacity && e.paints[0].type === type && e.paints[0].color.r === color.r && e.paints[0].color.g === color.g && e.paints[0].color.b === color.b)
              return true;
          });
          if (!style)
            lintData.nonStdBg.push({ name: node.name, id: node.id, type: node.type });
        }
      }
    strokeCheck:
      if ("strokes" in node) {
        let strokes = clone(node.strokes);
        if (strokes.length === 0)
          break strokeCheck;
        if (strokes.length > 1) {
          lintData.nonStdStroke.push({ name: node.name, id: node.id, type: node.type });
          break strokeCheck;
        }
        if (node.strokeStyleId) {
          let strokeStyleId = node.strokeStyleId;
          let localPaintStyle = figma.getLocalPaintStyles();
          let localStyle = localPaintStyle.find((e) => isSameId(e.id, strokeStyleId));
          if (localStyle) {
            lintData.localStroke.push({ name: node.name, id: node.id, type: node.type });
            break strokeCheck;
          }
          let style = data_default.paintStyles.find((e) => isSameId(e.id, strokeStyleId));
          if (!style)
            lintData.otherLibStroke.push({ name: node.name, id: node.id, type: node.type });
        } else {
          let { opacity, type, color } = strokes[0];
          let style = data_default.paintStyles.find((e) => {
            if (e.paints[0].opacity === opacity && e.paints[0].type === type && e.paints[0].color.r === color.r && e.paints[0].color.g === color.g && e.paints[0].color.b === color.b)
              return true;
          });
          if (!style)
            lintData.nonStdStroke.push({ name: node.name, id: node.id, type: node.type });
        }
      }
    if ("children" in node && node.children.length > 0) {
      lintNodes(node.children);
    }
  }
  function lintNodes(nodes) {
    nodes.forEach((e) => lint(e));
  }
  figma.showUI(__html__);
  lintNodes(figma.currentPage.selection);
  console.log(lintData);
})();
