const fs = require('fs');
const deskvariables = {
  /* dot variables */
  '--dot_bg_black': '#000',
  '--dot_text_black': '#000',
  '--dot_border_black': '#000',
  '--dot_shadow_black': '#000',
  '--dot_bg_bunker': '#1e2633',
  '--dot_text_bunker': '#1e2633',
  '--dot_border_bunker': '#1e2633',
  '--dot_shadow_bunker': '#1e2633',
  '--dot_bg_shuttleGrey': '#5a616f',
  '--dot_text_shuttleGrey': '#5a616f',
  '--dot_border_shuttleGrey': '#5a616f',
  '--dot_shadow_shuttleGrey': '#5a616f',
  '--dot_bg_slateGrey': '#788190',
  '--dot_text_slateGrey': '#788190',
  '--dot_border_slateGrey': '#788190',
  '--dot_shadow_slateGrey': '#788190',
  '--dot_bg_white': '#fff',
  '--dot_text_white': '#fff',
  '--dot_border_white': '#fff',
  '--dot_shadow_white': '#fff',
  '--dot_bg_paleNavy': '#c8cbdc',
  '--dot_text_paleNavy': '#c8cbdc',
  '--dot_border_paleNavy': '#c8cbdc',
  '--dot_shadow_paleNavy': '#c8cbdc',
  '--dot_bg_paleBlue': '#d5dde7',
  '--dot_text_paleBlue': '#d5dde7',
  '--dot_border_paleBlue': '#d5dde7',
  '--dot_shadow_paleBlue': '#d5dde7',
  '--dot_bg_hawkesBlue': '#e7ecf4',
  '--dot_text_hawkesBlue': '#e7ecf4',
  '--dot_border_hawkesBlue': '#e7ecf4',
  '--dot_shadow_hawkesBlue': '#e7ecf4',
  '--dot_bg_solitude': '#ebf0f5',
  '--dot_text_solitude': '#ebf0f5',
  '--dot_border_solitude': '#ebf0f5',
  '--dot_shadow_solitude': '#ebf0f5',
  '--dot_bg_catskillWhite': '#f6f8fb',
  '--dot_text_catskillWhite': '#f6f8fb',
  '--dot_border_catskillWhite': '#f6f8fb',
  '--dot_shadow_catskillWhite': '#f6f8fb',
  '--dot_bg_primary': '#0a73eb',
  '--dot_text_primary': '#0a73eb',
  '--dot_border_primary': '#0a73eb',
  '--dot_shadow_primary': '#0a73eb',
  '--dot_bg_brightRed': '#de3535',
  '--dot_text_brightRed': '#de3535',
  '--dot_border_brightRed': '#de3535',
  '--dot_shadow_brightRed': '#de3535',
  '--dot_bg_vividOrange': '#ff6f00',
  '--dot_text_vividOrange': '#ff6f00',
  '--dot_border_vividOrange': '#ff6f00',
  '--dot_shadow_vividOrange': '#ff6f00',
  '--dot_bg_strongGreen': '#26a942',
  '--dot_text_strongGreen': '#26a942',
  '--dot_border_strongGreen': '#26a942',
  '--dot_shadow_strongGreen': '#26a942',
  '--dot_bg_brightOrange': '#f6b041',
  '--dot_text_brightOrange': '#f6b041',
  '--dot_border_brightOrange': '#f6b041',
  '--dot_shadow_brightOrange': '#f6b041',
  '--dot_bg_lavender': '#ecf4fd',
  '--dot_text_lavender': '#ecf4fd',
  '--dot_border_lavender': '#ecf4fd',
  '--dot_shadow_lavender': '#ecf4fd',
  '--dot_bg_aliceBlue': '#f1f7fe',
  '--dot_text_aliceBlue': '#f1f7fe',
  '--dot_border_aliceBlue': '#f1f7fe',
  '--dot_shadow_aliceBlue': '#f1f7fe',
  '--dot_bg_cobalt': '#0053b8',
  '--dot_text_cobalt': '#0053b8',
  '--dot_border_cobalt': '#0053b8',
  '--dot_shadow_cobalt': '#0053b8',
  '--dot_bg_fireBrick': '#ab1a18',
  '--dot_text_fireBrick': '#ab1a18',
  '--dot_border_fireBrick': '#ab1a18',
  '--dot_shadow_fireBrick': '#ab1a18',
  '--dot_bg_ochre': '#c2861f',
  '--dot_text_ochre': '#c2861f',
  '--dot_border_ochre': '#c2861f',
  '--dot_shadow_ochre': '#c2861f',
  '--dot_bg_tawny': '#cc5c00',
  '--dot_text_tawny': '#cc5c00',
  '--dot_border_tawny': '#cc5c00',
  '--dot_shadow_tawny': '#cc5c00',
  '--dot_bg_camarone': '#0e7526',
  '--dot_text_camarone': '#0e7526',
  '--dot_border_camarone': '#0e7526',
  '--dot_shadow_camarone': '#0e7526',
  '--dot_bg_tropicalBlue': '#b7d1f0',
  '--dot_text_tropicalBlue': '#b7d1f0',
  '--dot_border_tropicalBlue': '#b7d1f0',
  '--dot_shadow_tropicalBlue': '#b7d1f0',
  '--dot_bg_whiteSmoke': '#fdf3f3',
  '--dot_text_whiteSmoke': '#fdf3f3',
  '--dot_border_whiteSmoke': '#fdf3f3',
  '--dot_shadow_whiteSmoke': '#fdf3f3',
  '--dot_bg_paleRed': '#fcebeb',
  '--dot_text_paleRed': '#fcebeb',
  '--dot_border_paleRed': '#fcebeb',
  '--dot_shadow_paleRed': '#fcebeb',
  '--dot_bg_tequila': '#f5d2a3',
  '--dot_text_tequila': '#f5d2a3',
  '--dot_border_tequila': '#f5d2a3',
  '--dot_shadow_tequila': '#f5d2a3',
  '--dot_bg_lightningYellow': '#fce3bd',
  '--dot_text_lightningYellow': '#fce3bd',
  '--dot_border_lightningYellow': '#fce3bd',
  '--dot_shadow_lightningYellow': '#fce3bd',
  '--dot_bg_oldLace': '#fef7ec',
  '--dot_text_oldLace': '#fef7ec',
  '--dot_border_oldLace': '#fef7ec',
  '--dot_shadow_oldLace': '#fef7ec',
  '--dot_bg_pattensBlue': '#cee3fb',
  '--dot_text_pattensBlue': '#cee3fb',
  '--dot_border_pattensBlue': '#cee3fb',
  '--dot_shadow_pattensBlue': '#cee3fb',
  '--dot_bg_floralWhite': '#fefaf4',
  '--dot_text_floralWhite': '#fefaf4',
  '--dot_border_floralWhite': '#fefaf4',
  '--dot_shadow_floralWhite': '#fefaf4',
  /* component pkg variables */
  '--zdt_avatar_default_boxshadow': 'rgba(0, 0, 0, 0.11)',
  '--zdt_avatar_white_boxshadow': 'rgba(255, 255, 255, 0.14)',
  '--zdt_dropbox_default_box_shadow': 'rgba(0, 0, 0, 0.13)',
  '--zdt_dropbox_mob_bg': 'rgba(0, 0, 0, 0.4)',
  '--zdt_dropbox_mob_close_bg': '#d5d5d5',
  '--zdt_dropbox_dark_bg': '#383f57',
  '--zdt_label_dark_text': '#d0d0d4',
  '--zdt_tag_dark_bg': '#42485f',
  '--zdt_tag_dark_text': '#d0d0d4',
  '--zdt_tag_dark_hover_bg': '#503348',
  '--zdt_tag_dark_close_bg': '#864654',
  '--zdt_tag_dark_close_text': '#de3535',
  '--zdt_tag_dark_close_hover_bg': '#de3535',
  '--zdt_dropdown_darkheading_bg': '#383f57',
  '--zdt_dropdown_darkheading_underline_bg': '#565e72',
  '--zdt_listitem_dark_bg': '#383f57',
  '--zdt_listitem_dark_text': '#d0d0d4',
  '--zdt_listitem_dark_effect_bg': '#444a61',
  '--zdt_listitem_dark_active_bg': '#3b4d6d',
  '--zdt_listitem_dark_tickicon': '#6cbbfc',
  '--zdt_stencil_dark_bg': '#383f55',
  '--zdt_stencil_dark_gradient_bg': '#414963',
  '--zdt_tooltip_default_bg': 'rgba(30, 38, 51, 0.95)',
  '--zdt_multiselect_dark_border': '#4b5168',
  '--zdt_multiselect_dark_hover_border': '#9699a6',
  '--zdt_multiselect_dark_active_border': '#9699a6',
  '--zdt_multiselect_darkdelete_text': '#9c9fab',
  '--zdt_multiselect_darkmsg_bg': '#383f57',
  '--zdt_multiselect_darkmsg_text': '#d0d0d4',
  '--zdt_advancedmultiselect_dark_border': '#4b5168',
  '--zdt_advancedmultiselect_dark_hover_border': '#9699a6',
  '--zdt_advancedmultiselect_dark_active_border': '#9699a6',
  '--zdt_rippleeffect_primary_dark_bg': '#e7f1fd',
  '--zdt_rippleeffect_green_bg': '#f2faf5',
  '--zdt_datetime_header_bg': '#f6f8fb',
  '--zdt_datetime_header_border': '#ebf0f5',
  '--zdt_datetime_datestr_hover_bg': '#ebf0f5',
  '--zdt_datetime_separator_border': '#d5dde7',
  '--zdt_datetime_daystr_text': '#788190',
  '--zdt_datetime_invalid_text': '#c8cbdc',
  '--zdt_datetime_invaliddate_text': 'rgba(222, 53, 53, 0.3)',
  '--zdt_datetime_text': '#5a616f',
  '--zdt_yearview_month_bg': '#f6f8fb',
  '--zdt_yearview_month_hover_bg': '#e7ecf4',
  '--zdt_yearview_yearbox_border': '#d5dde7',
  '--zdt_yearview_yeartext_text': '#788190',
  '--zdt_datewidget_placeholder_selection_bg': '#b4d5fe',
  /* dot pkg variables */
  '--zdt_actionButton_bg': '#479dff',
  '--zdt_actionButton_hover_bg': '#1065cc',
  '--zdt_actionButton_separator_border': 'rgba(255, 255, 255, 0.15)',
  '--zdt_alertheader_default_text': '#e2e4e6',
  '--zdt_alertheader_primary_bg': '#edfbfe',
  '--zdt_alertheader_danger_text': '#ff6b6b',
  '--zdt_alphabeticList_text': '#828994',
  '--zdt_alphabeticList_hover_text': '#479dff',
  '--zdt_attachment_default_bg': '#232b38',
  '--zdt_attachment_default_border': '#3e4d63',
  '--zdt_attachment_default_hover_border': '#828994',
  '--zdt_attachment_hover_text': '#e2e4e6',
  '--zdt_attachment_size_text': '#a8b0bd',
  '--zdt_attachment_download_bg': '#161b23',
  '--zdt_attachment_download_hover_bg': '#828994',
  '--zdt_attachment_download_hover_text': '#232b38',
  '--zdt_avatarcollision_on_border': '#479dff',
  '--zdt_avatarcollision_off_border': '#384157',
  '--zdt_avatarcollision_off_after_border': '#232b38',
  '--zdt_avatarcollision_off_after_bg': '#384157',
  '--zdt_avatarcollision_icon_text': '#232b38',
  '--zdt_avatarIcon_dark_icon': '#e2e4e6',
  '--zdt_avatarIcon_danger_icon': '#ff6b6b',
  '--zdt_avatarIcon_primary_icon': '#479dff',
  '--zdt_avatarIcon_grey_icon': '#a8b0bd',
  '--zdt_avatarIcon_success_icon': '#4ac064',
  '--zdt_avatarIcon_default_border': '#3e4d63',
  '--zdt_avatarIcon_default_hover_border': '#828994',
  '--zdt_avatarIcon_primary_border': '#479dff',
  '--zdt_avatarIcon_primary_hover_border': '#1065cc',
  '--zdt_avatarIcon_success_border': '#4ac064',
  '--zdt_avatarIcon_success_hover_border': '#1b8c35',
  '--zdt_avatarIcon_danger_border': '#ff6b6b',
  '--zdt_avatarIcon_danger_hover_border': '#cc302d',
  '--zdt_avatarstatus_size_border': '#232b38',
  '--zdt_avatarstatus_online_bg': '#4ac064',
  '--zdt_avatarstatus_offline_bg': '#3e4d63',
  '--zdt_avatarstatus_idle_bg': '#ff801f',
  '--zdt_avatarthread_bg': '#232b38',
  '--zdt_avatarthread_default_border': '#384157',
  '--zdt_avatarthread_default_text': '#a8b0bd',
  '--zdt_avatarthread_primary_border': '#479dff',
  '--zdt_avatarthread_primary_text': '#479dff',
  '--zdt_avatarthread_success_border': '#4ac064',
  '--zdt_avatarthread_success_text': '#4ac064',
  '--zdt_avatarthread_danger_border': '#ff6b6b',
  '--zdt_avatarthread_danger_text': '#ff6b6b',
  '--zdt_avataruser_default_bg': '#232b38',
  '--zdt_avataruser_delete_text': '#232b38',
  '--zdt_avatarteam_default_bg': '#232b38',
  '--zdt_channelIcon_icon': '#e2e4e6',
  '--zdt_channelIcon_topIcon_bg': '#232b38',
  '--zdt_channelIcon_topIcon_iconGreen': '#4ac064',
  '--zdt_channelIcon_topIcon_iconYellow': '#ff6b6b',
  '--zdt_channelIcon_topIcon_border': '#384157',
  '--zdt_drawer_default_box_shadow': 'rgba(0, 0, 0, 0.2)',
  '--zdt_drawer_default_bg': '#232b38',
  '--zdt_drawer_header_bg': '#262f3d',
  '--zdt_drawer_header_border': '#384157',
  '--zdt_drawer_title_text': '#e2e4e6',
  '--zdt_toggledropdown_line_border': '#2d3748',
  '--zdt_commonEmptyState_default_title': '#e2e4e6',
  '--zdt_commonEmptyState_default_description': '#a8b0bd',
  '--zdt_commonEmptyState_dark_title': '#fff',
  '--zdt_commonEmptyState_dark_description': '#fff',
  '--zdt_commonEmptyState_dark_link': '#6cbbfc',
  '--zdt_commonEmptyState_dark_link_hover': '#2469ff',
  '--zdt_editionpage_primary_text': '#479dff',
  '--zdt_emptystate_default_bg': '#232b38',
  '--zdt_linktext_default_text': '#479dff',
  '--zdt_unabletoprocess_heading_text': '#479dff',
  '--zdt_unauthorized_heading_text': '#479dff',
  '--zdt_fields_phoneicon_icon': '#e2e4e6',
  '--zdt_fields_phoneicon_hover_icon': '#4ac064',
  '--zdt_fields_lockicon_icon': '#a8b0bd',
  '--zdt_fields_lockicon_hover_icon': '#ff6b6b',
  '--zdt_formAction_bg': '#232b38',
  '--zdt_formAction_border': '#2d3748',
  '--zdt_freezelayer_default_bg': 'rgba(0, 0, 0, 0.80)',
  '--zdt_freezelayer_dark_bg': 'rgba(0, 0, 0, 0.80)',
  '--zdt_freezelayer_darklight_bg': 'rgba(27, 33, 43, 0.95)',
  '--zdt_freezelayer_snow_bg': 'rgba(44, 51, 77, 0.45)',
  '--zdt_iconButton_icon_black': '#e2e4e6',
  '--zdt_iconButton_icon_primary': '#479dff',
  '--zdt_iconButton_icon_primaryHover': '#1065cc',
  '--zdt_importantnotes_icon': '#e2e4e6',
  '--zdt_setupdetail_popup_bg': '#232b38',
  '--zdt_subtablayout_border': '#2d3748',
  '--zdt_subtablayout_tabhead_bg': '#232b38',
  '--zdt_subtablayout_title_text': '#479dff',
  '--zdt_avatarflip_default_text': '#e2e4e6',
  '--zdt_comment_iconText': '#a8b0bd',
  '--zdt_departmentdropdown_default_text': '#828994',
  '--zdt_departmentdropdown_default_hover_text': '#e2e4e6',
  '--zdt_dot_text': '#3e4d63',
  '--zdt_dotnew_default_bg': '#479dff',
  '--zdt_dotnew_default_box_shadow': 'rgba(10, 115, 235, 0.6)',
  '--zdt_dotnew_animate_to_box_shadow': 'rgba(255, 255, 255, 0)',
  '--zdt_gridstencils_default_bg': '#232b38',
  '--zdt_gridstencils_listbar_bg': '#f6f7f8',
  '--zdt_gridstencils_listbar_gradient_bg': '#edeef1',
  '--zdt_icons_default': '#a8b0bd',
  '--zdt_icons_hover_blue': '#479dff',
  '--zdt_icons_hover_red': '#ff6b6b',
  '--zdt_listLayout_border': '#2d3748',
  '--zdt_liststencils_innercontainer_border': '#2d3748',
  '--zdt_secondaryText_gray_text': '#a8b0bd',
  '--zdt_secondaryText_orage_text': '#ff801f',
  '--zdt_secondaryText_green_text': '#4ac064',
  '--zdt_secondaryText_red_text': '#ff6b6b',
  '--zdt_secondaryText_blue_text': '#479dff',
  '--zdt_secondaryText_black_text': '#e2e4e6',
  '--zdt_secondaryText_secondaryText_text': '#a8b0bd',
  '--zdt_statusdropdown_line_border': '#2d3748',
  '--zdt_statuslistitem_list_text': '#e2e4e6',
  '--zdt_statuslistitem_default_active_border': '#479dff',
  '--zdt_statuslistitem_secondary_effect_bg': '#479dff',
  '--zdt_statuslistitem_secondary_effect_text': '#232b38',
  '--zdt_statuslistitem_tickicon': '#479dff',
  '--zdt_statuslistitem_black_bg': '#e2e4e6',
  '--zdt_statuslistitem_orange_bg': '#ff801f',
  '--zdt_statuslistitem_green_bg': '#4ac064',
  '--zdt_subject_text': '#e2e4e6',
  '--zdt_tagnew_default_bg': '#479dff',
  '--zdt_tagnew_default_box_shadow': 'rgba(10, 115, 235, 0.4)',
  '--zdt_thread_iconText': '#a8b0bd',
  '--zdt_usertime_timeText': '#a8b0bd',
  '--zdt_usertime_icon_red': '#ff6b6b',
  '--zdt_usertime_icon_green': '#4ac064',
  '--zdt_usertime_icon_orange': '#ff801f',
  '--zdt_usertime_icon_gray': '#a8b0bd',
  '--zdt_loader_gradient_bg1': '#ce2232',
  '--zdt_loader_gradient_bg2': '#608040',
  '--zdt_loader_gradient_bg3': '#90b247',
  '--zdt_loader_gradient_bg4': '#f9dd4b',
  '--zdt_loader_gradient_bg5': '#0974b0',
  '--zdt_loader_gradient_bg6': '#ce2232',
  '--zdt_lookupheader_default_bg': '#262f3d',
  '--zdt_lookupheader_default_border': '#384157',
  '--zdt_lookupheader_para_text': '#a8b0bd',
  '--zdt_lookupclose_default_hover_text': '#e2e4e6',
  '--zdt_lookupsearch_boxstyle_border': '#384157',
  '--zdt_lookupsearch_boxstyle_hover_border': '#828994',
  '--zdt_lookupsearch_boxstyle_activer_border': '#479dff',
  '--zdt_lookuptitle_default_text': '#e2e4e6',
  '--zdt_lookuptitle_primary_text': '#479dff',
  '--zdt_lookuptitle_danger_text': '#ff6b6b',
  '--zdt_viewdropdown_empty_text': '#828994',
  '--zdt_viewdropdown_label_text': '#a8b0bd',
  '--zdt_viewdropdown_hover_label_text': '#e2e4e6',
  '--zdt_lookupsection_bg': '#232b38',
  '--zdt_lookupsection_box_shadow': 'rgba(0, 0, 0, 0.4)',
  '--zdt_message_default_box_shadow': 'rgba(0, 0, 0, 0.15)',
  '--zdt_message_default_bg': '#232b38',
  '--zdt_message_success_bg': '#4ac064',
  '--zdt_message_alert_bg': '#ff6b6b',
  '--zdt_message_tickicon': '#232b38',
  '--zdt_messagebanner_text': '#e2e4e6',
  '--zdt_messagebanner_link_text': '#479dff',
  '--zdt_messagebanner_close_hover_bg': '#ececc6',
  '--zdt_messagebanner_default_bg': '#feffdd',
  '--zdt_messagebanner_blue_bg': '#eaf4fe',
  '--zdt_messagebanner_white_text': '#232b38',
  '--zdt_newstar_green_text': '#4ac064',
  '--zdt_newstar_blue_text': '#479dff',
  '--zdt_search_input_border': '#999',
  '--zdt_search_input_text': '#333',
  '--zdt_search_input_focus_border': '#0d83dd',
  '--zdt_search_icon': '#999',
  '--zdt_search_hover_icon': '#666',
  '--zdt_views_icon': '#999',
  '--zdt_views_border': '#e1e1e1',
  '--zdt_views_hover_icon': '#666',
  '--zdt_views_active_icon': '#0d83dd',
  '--zdt_helptipslink_text': '#479dff',
  '--zdt_tabletext_primary_text': '#479dff',
  '--zdt_tabletext_default_text': '#e2e4e6',
  '--zdt_tabletext_danger_text': '#ff6b6b',
  '--zdt_toastmessage_default_box_shadow': 'rgba(0, 0, 0, 0.3)',
  '--zdt_toastmessage_default_bg': '#232b38',
  '--zdt_toastmessage_alert_border': '#384157',
  '--zdt_toastmessage_alert_text': '#e2e4e6',
  '--zdt_toastmessage_alerttitle_text': '#fff',
  '--zdt_toastmessage_popbutton_text': '#e2e4e6',
  '--zdt_toastmessage_submit_border': '#384157',
  '--zdt_toastmessage_primary_text': '#479dff',
  '--zdt_toastmessage_primary_hover_bg': '#479dff',
  '--zdt_toastmessage_primary_hover_text': '#fff',
  '--zdt_toastmessage_danger_text': '#ff6b6b',
  '--zdt_toastmessage_danger_hover_bg': '#ff6b6b',
  '--zdt_toastmessage_danger_text_shadow': '#e34a4c',
  '--zdt_toastmessage_cancel_hover_text': '#e2e4e6',
  '--zdt_toastmessage_closeicon': '#828994',
  '--zdt_toastmessage_closeicon_hover_text': '#828994',
  '--zdt_toastmessage_dropdown_bg': '#262f3d',
  '--zdt_toastmessage_message_border': '#384157',
  '--zdt_upload_bg': '#fff1e6',
  '--zdt_upload_attachsize_text': '#828994',
  '--zdt_upload_uploadclose_bg': '#828994',
  '--zdt_upload_uploadclose_text': '#232b38',
  '--zdt_commonalert_default_border': '#ff6b6b',
  '--zdt_commonalert_success_border': '#4ac064',
  '--zdt_commonalert_info_border': '#479dff',
  '--zdt_commonalert_danger_border': '#ff6b6b',
  '--zdt_commonalert_error_border': '#ff6b6b',
  '--zdt_commonalert_warning_border': '#ff801f',
  '--zdt_commonalert_close_icon': '#828994',
  '--zdt_commonalert_success_hover_bg': '#e9f7ef',
  '--zdt_commonalert_info_hover_bg': '#253142',
  '--zdt_commonalert_warning_hover_bg': '#fff1e6',
  '--zdt_commonalert_light_hover_bg': '#262f3d',
  '--zdt_commonalert_secondlayer_bg': '#262f3d',
  '--zdt_commonalert_icon': '#ff6b6b',
  '--zdt_commonalert_success_icon': '#4ac064',
  '--zdt_commonalert_info_icon': '#479dff',
  '--zdt_commonalert_danger_icon': '#ff6b6b',
  '--zdt_commonalert_error_icon': '#ff6b6b',
  '--zdt_commonalert_warning_icon': '#ff801f',
  '--zdt_alerticons_green_fill': '#4ac064',
  '--zdt_alerticons_primary_fill': '#479dff',
  '--zdt_alerticons_orange_fill': '#ff801f',
  '--zdt_globalnotification_success_bg': '#f2faf5',
  '--zdt_globalnotification_info_bg': '#f0f7fe',
  '--zdt_globalnotification_warning_bg': '#fff6f0',
  '--zdt_alertlookup_bg': '#232b38',
  '--zdt_alertlookup_border': '#2d3748',
  '--zdt_alertlookuop_text': '#e2e4e6',
  '--zdt_alertlookupnew_text': '#e2e4e6',
  '--zdt_tagsmultiselect_labelt_text': '#a8b0bd',
  '--zdt_tagsmultiselect_dark_border': '#4b5168',
  '--zdt_tagsmultiselect_dark_hover_border': '#9699a6',
  '--zdt_tagsmultiselect_dark_active_border': '#9699a6',
  '--zdt_texteditor_menu_after_box_shadow': 'rgba(0, 0, 0, 0.08)',
  '--zdt_texteditor_dropdown_box_shadow': 'rgba(0, 0, 0, 0.2)',
  /* supportapp components theme folder variables */
  '--zdt_re_card_box_shadow_default': 'rgba(0, 0, 0, 0.04)',
  '--zdt_boxlegend_box_shadow_default': 'rgba(0, 0, 0, 0.1)',
  '--zdt_boxlegend_bg_primary': 'rgba(10, 115, 235, 0.06)',
  '--zdt_boxlegend_icon_bg_primary': 'rgba(10, 115, 235, 0.08)',
  '--zdt_boxlegend_bg_red': 'rgba(222, 53, 53, 0.06)',
  '--zdt_boxlegend_icon_bg_red': 'rgba(222, 53, 53, 0.08)',
  '--zdt_boxlegend_bg_green': 'rgba(38, 169, 66, 0.06)',
  '--zdt_boxlegend_icon_bg_green': 'rgba(38, 169, 66, 0.08)',
  '--zdt_boxlegend_bg_orange': 'rgba(255, 111, 0, 0.06)',
  '--zdt_boxlegend_icon_bg_orange': 'rgba(255, 111, 0, 0.08)',
  '--zdt_boxlegend_bg_black': 'rgba(0, 0, 0, 0.06)',
  '--zdt_boxlegend_icon_bg_black': 'rgba(0, 0, 0, 0.08)',
  '--zdt_topLegend_box_shadow_default': 'rgba(0, 0, 0, 0.04)',
  '--zdt_avatarChannel_box_shadow_default': 'rgba(0, 0, 0, 0.08)',
  '--zdt_re_form_notes_text': '#4f3b0b',
  '--zdt_re_form_notes_bg': '#fff9eb',
  '--zdt_re_grid_box_shadow': 'rgba(241, 242, 244, 1)',
  '--zdt_re_grid_text_disabled': 'rgba(90, 97, 111, 0.35)',
  '--zdt_re_grid_box_shadow_hover': 'rgba(228, 230, 233, 1)',
  '--zdt_re_detailLayout_leftPanel_bg': '#eceff3',
  '--zdt_bp_button_box_shadow': 'rgba(0, 0, 0, 0.2)',
  '--zdt_bp_active_box_shadow': 'rgba(47, 148, 238, 0.2)',
  '--zdt_bp_onhold_after_border': '#f88825',
  '--zdt_bp_closed_after_border': '#4ad251',
  '--zdt_bpflowchart_listcont_after_bg': '#c1cdd3',
  '--zdt_bpflowchart_leftline_before_bg': '#515151',
  '--zdt_blueprint_footer_bg': '#e8f6ff',
  '--zdt_blueprint_footer_border': 'rgba(178, 190, 197, 0.38)',
  '--zdt_blueprint_footer_arrow_icon': '#cedde5',
  '--zdt_bp_morepopup_hover_border': '#c2e9ff',
  '--zdt_bp_morepopup_open_box_shadow': 'rgba(0, 163, 254, 0.09)',
  '--zdt_blueprint_transition_shadow_hover': 'rgba(47, 148, 238, 0.4)',
  '--zdt_bp_footerlanding_footer_border': 'rgba(178, 190, 197, 0.38)',
  '--zdt_bp_footerlanding_footer_bg': '#e8f6ff',
  '--zdt_bp_formfields_notesarea_bg': '#fff9eb',
  '--zdt_bp_formfields_notesarea_text': '#4f3b0b',
  '--zdt_bp_formfields_notesarea_box_shadow': 'rgba(251, 192, 46, 0.2)',
  '--zdt_bp_formfields_invalid_bg': '#ffeded',
  '--zdt_bp_transitionactions_switch_hover_bg': 'rgba(47, 148, 238, 0.1)',
  '--zdt_bp_transitionactions_switch_box_shadow': 'rgba(0, 0, 0, 0.1)',
  '--zdt_bp_transitionform_continues_bg': '#e8f6ff',
  '--zdt_bp_transitionform_continues_border': 'rgba(178, 190, 197, 0.38)',
  '--zdt_bp_transitionlist_disable_bg': '#ef8b00',
  '--zdt_bp_transitionlist_failed_bg': '#e24b4b',
  '--zdt_dv_bg': '#eceff3',
  '--zdt_dv_peekCloseIcon_shadow': 'rgba(0, 0, 0, 0.09)',
  '--zdt_dv_peek_left_shadow': 'rgba(0, 0, 0, 0.06)',
  '--zdt_commentList_public_bg': '#edf4fd',
  '--zdt_commentList_public_border': '#bdd9f9',
  '--zdt_commentList_private_bg': '#fefcf3',
  '--zdt_commentList_private_border': '#f8eaae',
  '--zdt_history_newDot_shadow': 'rgba(38, 169 ,66 , 0.2)',
  '--zdt_tagWithIconBlue_bg': '#e7f1fd',
  '--zdt_tagWithIconBlue_border': '#bdd9f9',
  '--zdt_tagWithIconYellow_bg': '#fefae8',
  '--zdt_tagWithIconYellow_border': '#f8eaae',
  '--zdt_tagWithIconYellow_text': '#f6a459',
  '--zdt_statusDropdown_black_border': '#dfe6f2',
  '--zdt_statusDropdown_orange_border': 'rgba(222, 53, 53, 0.2)',
  '--zdt_statusDropdown_green_bg': '#f2faf5',
  '--zdt_statusDropdown_green_border': 'rgba(38, 169, 66, 0.2)',
  '--zdt_statusDropdown_red_border': 'rgba(222, 53, 53, 0.2)',
  '--zdt_ticketShare_shadow': 'rgba(0, 0, 0, 0.06)',
  '--zdt_dv_marketPlace_icon_middle_border': '#333',
  '--zdt_dv_marketPlace_icon_bottom_border': '#666766',
  '--zdt_starredtemplates_helper_box_shadow': 'rgba(0, 0, 0, 0.1)',
  '--zdt_twotoneIcon_primary_bg': 'rgba(200, 203, 220, 0.5)',
  '--zdt_twotoneIcon_secondary_bg': 'rgba(200, 203, 220, 0.7)',
  '--zdt_twotoneIcon_danger_bg': 'rgba(222, 53, 53, 0.3)',
  '--zdt_application_color': '#000',
  '--zdt_ribbonNew_primary_bg': '#e7f1fd',
  '--zdt_customscroll_default_bg': 'rgba(255, 255, 255, 0.1)',
  '--zdt_customscroll_thump_bg': 'rgba(44, 51, 77, 0.2)',
  '--zdt_customscroll_thump_dark_bg': 'rgba(255, 255, 255, 0.2)',
  '--zdt_customscroll_thump_hover_bg': 'rgba(44, 51, 77, 0.3)',
  '--zdt_customscroll_thump_dark_hover_bg': 'rgba(255, 255, 255, 0.4)',
  '--zdt_customscroll_border': 'rgba(44, 51, 77, 0.1)',
  '--zdt_customscroll_dark_border': 'rgba(255, 255, 255, 0.07)',
  '--zdt_attachmentviewer_header_bg': '#2c334d',
  '--zdt_attachmentviewer_arrow_border': '#4e556c',
  '--zdt_attachmentviewer_footer_bg': '#2c334d',
  '--zdt_attachmentviewer_footer_border': '#2c334d',
  '--zdt_attachmentviewer_selected_box_shadow': 'rgba(0, 0, 0, 0.34)',
  '--zdt_attachmentviewer_loader_border': '#2a2e38',
  '--zdt_attachmentviewer_loader_border_top': '#f3f3f3',
  '--zdt_listpagination_default_bg': 'rgba(131, 134, 146, 0.9)',
  '--zdt_listpagination_arrow_hover_bg': 'rgba(131, 134, 146, 1)',
  '--zdt_teamslist_teamuser_bg': 'rgba(0, 163, 254, 0.08)',
  '--zdt_menucontainer_link_text_shadow': 'rgba(0, 0, 0, 0.75)',
  '--zdt_failuredetails_default_box_shadow': 'rgba(0, 0, 0, 0.25)',
  '--zdt_failuredetails_mailalert_border': '#f1dbdb',
  '--zdt_failuredetails_mailalert_bg': '#fdf4f4',
  '--zdt_failuredetails_footer_box_shadow': 'rgba(0, 0, 0, 0.1)',
  '--zdt_keyboards_key_box_shadow': '#2a323e',
  '--zdt_keyboards_keyboardpad_bg': '#e1e1e3',
  '--zdt_keygroupsection_bg': 'rgba(42, 45, 54, 0.94)',
  '--zdt_keypad_secondary_bg': 'rgba(42, 45, 54, 0.2)',
  '--zdt_leftband_bg': '#2c334d',
  '--zdt_leftband_bg_dark3': '#383f57',
  '--zdt_leftband_bg_dark4': '#444a61',
  '--zdt_leftband_bg_dark5': '#565e72',
  '--zdt_leftband_bg_pure': '#fff',
  '--zdt_leftband_text_pure': '#fff',
  '--zdt_leftband_text_gray': '#d0d0d4',
  '--zdt_leftband_text_slateGrey': '#788190',
  '--zdt_leftband_text_dark3': '#9c9fab',
  '--zdt_leftband_text_dark4': '#61667a',
  '--zdt_leftband_text_dark5': '#5f6478',
  '--zdt_leftband_hover_dark': '#383f57',
  '--zdt_leftband_hover_dark2': '#444a61',
  '--zdt_leftband_hover_dark3': '#9699a6',
  '--zdt_leftband_hover_dark4': '#333a53',
  '--zdt_leftband_hover_slateGrey': '#788190',
  '--zdt_leftband_hover_primary': '#2469ff',
  '--zdt_leftband_text_primary': '#6cbbfc',
  '--zdt_leftband_border_pure': '#fff',
  '--zdt_leftband_border_dark': '#42485f',
  '--zdt_leftband_border_dark1': '#4b5168',
  '--zdt_leftband_border_dark2': '#565e72',
  '--zdt_ticketleftmenu_default_box_shadow': 'rgba(44, 51, 77, 1)',
  '--zdt_homelayout_leftpanel_border': '#42485f',
  '--zdt_queuecolumn_opencolumn_box_shadow': 'rgba(0, 0, 0, 0.05)',
  '--zdt_globalsearch_popcontainer_bg': 'rgba(30, 38, 51, 0.6)',
  '--zdt_searchbtn_default_hover_box_shadow': 'rgba(0, 163, 254, 0.4)',
  '--zdt_searchleftpanel_datatitle_border': '#555b70',
  '--zdt_resultlistheader_default_after_box_shadow': 'rgba(0, 0, 0, 0.3)',
  '--zdt_snippetonboard_skip_text': 'rgba(221, 221, 221, 0.6)',
  '--zdt_snippetpart_skip_text': 'rgba(221, 221, 221, 0.6)',
  '--zdt_snippetpointer_iconstar_text_shadow': 'rgba(0, 163, 254, 0.6)',
  '--zdt_tableview_sorticon_path1_color': '#000',
  '--zdt_tableview_sorticon_path2_color': '#333',
  '--zdt_linkdata_data_hover_border': 'rgba(47, 148, 238, 0.55)',
  '--zdt_tablerow_border': '#f3f6f9',
  '--zdt_tableviewpage_disable_bg': 'rgba(255, 255, 255, 0.55)',
  '--zdt_topbar_button_bg': '#0a73eb',
  '--zdt_topbar_button_hover_bg': '#0053b8',
  '--zdt_topbar_button_border': '#2381ed',
  '--zdt_topbar_bg': '#2c334d',
  '--zdt_topbar_changebtn_bg': '#ff6f00',
  '--zdt_topbar_badge_danger_bg': '#de3535',
  '--zdt_topbar_hover_dark': '#383f57',
  '--zdt_userinfo_header_online_bg': '#fcfffb',
  '--zdt_userinfo_header_online_bg1': '#f4feef',
  '--zdt_userinfo_header_offline_bg': '#fdfdfd',
  '--zdt_userinfo_header_shadow': 'rgba(0, 0, 0, 0.05)',
  '--zdt_userinfo_avatarOnline_text': '#d5e4cd',
  '--zdt_userinfo_avatarOnline_bg': '#edf9e7',
  '--zdt_userinfo_appsTile_shadow': 'rgba(0, 0, 0, 0.03)',
  '--zdt_userinfo_appsTile_shadow_hover': 'rgba(0, 0, 0, 0.07)',
};

/* General Utility Functions
-----------------------------------*/

function $(a, b = document) {
  return b.querySelector(a);
}
function $all(a, b = document) {
  return [...b.querySelectorAll(a)];
}
function rand(min, max) {
  return Math.floor(Math.random() * (max - min + 1) + min);
}
function applyStyle(el, style) {
  Object.assign(el.style, style);
}
const compose = (...fn) => (arg) => fn.reduce((a, e) => e(a), arg);

/*  Utility Functions
----------------------------*/

function getHexArray(str) {
  let hex = str.trim().toLowerCase().replace(/^#/, '');
  hex = hex.length === 3 ? `${hex}${hex}` : hex;
  const result = hex.match(/(\d|[a-f]){2}/g);
  if (!result || result.length !== 3) throw new Error('Invalid Hex String');
  return result;
}
function hexToDecimal(ary) {
  let hex = ary;
  if (!Array.isArray(ary)) hex = getHexArray(hex);
  return hex.map((c) => parseInt(c, 16));
}
function removeDuplicate(ary) {
  return [...new Set(ary)];
}
function getValuesArray(obj) {
  return Object.values(obj);
}
function toLowerCase(ary) {
  return ary.map((el) => el.toLowerCase());
}

const render = (minHex, maxHex) => (ary = colorObjAry) => {
  const colors = ary.filter((c) => c.hsl.h >= minHex && c.hsl.h <= maxHex);
  const accent = colors.filter((c) => c.hsl.s >= 50 && c.alpha === false);
  const grey = colors.filter((c) => c.hsl.s < 50 && c.alpha === false);
  const accentOpace = colors.filter((c) => c.alpha === true && c.hsl.s >= 50);
  const greyOpace = colors.filter((c) => c.alpha === true && c.hsl.s < 50);

  sortByLightness(accent);
  sortByLightness(grey);
  sortByOpacity(accentOpace);
  sortByOpacity(greyOpace);

  function sortByLightness(ary) {
    ary.sort((a, b) => {
      const m = a.hsl.l,
        n = b.hsl.l;
      if (m === n) return 0;
      else return m > n ? -1 : 1;
    });
  }
  function sortByOpacity(ary) {
    ary.sort((a, b) => {
      const m = a.hsla.a,
        n = b.hsla.a;
      if (m === n) return 0;
      else return m > n ? 1 : -1;
    });
  }
  function getTile({ hsl, hex }) {
    return `
      <div class="tile" style="background-color: ${hex}">
          <div class="specs"><div class="hsl">
          ${hsl.h} &nbsp;${hsl.s} &nbsp;${hsl.l}
    </div>
    <div class="hex">${hex.toUpperCase()}</div></div>
      </div>`;
  }
  function getOpaceTile({ hsla, hex, rgba }) {
    return `
      <div class="tile" style="background-color: rgba(${rgba})">
          <div class="specs"><div class="hsl">
          ${hsla.h} &nbsp;${hsla.s} &nbsp;${hsla.l} &nbsp;${hsla.a}
    </div>
    <div class="hex">${hex.toUpperCase()}</div></div>
      </div>`;
  }

  let sec = document.createElement('section');
  sec.innerHTML = `
    <header class="sep1 h1">Hue ${minHex}° – ${maxHex}°</header>
    <div>
        <p class="h2">Accent (${accent.length})</p>
        <section class="grid accent">
            ${accent.map((hex) => getTile(hex)).join('')}
        </section>
    </div>
    <div>
    <p class="h2">Accent-Opace (${accentOpace.length})</p>
        <section class="grid grey">
            ${accentOpace.map((hex) => getOpaceTile(hex)).join('')}
        </section>
    </div>
    <p class="h2">Grey (${grey.length})</p>
        <section class="grid grey">
            ${grey.map((hex) => getTile(hex)).join('')}
        </section>
    </div>
    <div>
    <p class="h2">Grey-Opace (${greyOpace.length})</p>
        <section class="grid grey">
            ${greyOpace.map((hex) => getOpaceTile(hex)).join('')}
        </section>
    </div>
    <div>
    
    `;
  $('main').appendChild(sec);
};

function createColorObj(ary) {
  return ary.map((c) => {
    if (/^rgba/.test(c)) {
      let rgba = c.match(/(\d|\.){1,4}/g);
      let hexa = rgba.map((h, i) => {
        if (i < 3) {
          let x = `0${parseInt(h).toString(16)}`.slice(-2);
          return x;
        }
        return Math.round(h * 100);
      });
      let hex = `#${hexa.slice(0, 3).join('')}`;
      let hsl = color.hexTohsl(hex);

      return {
        alpha: true,
        HEX: hex,
        HSL: hsl,
        HSLA: { ...hsl, a: hexa[3] },
        RGB: {
          r: +rgba[0],
          g: +rgba[1],
          b: +rgba[2],
        },
        RGBA: {
          r: +rgba[0],
          g: +rgba[1],
          b: +rgba[2],
          a: +(rgba[3] * 100),
        },
        FigmaRGBA: {
          r: +rgba[0] / 255,
          g: +rgba[1] / 255,
          b: +rgba[2] / 255,
          a: +rgba[3],
        },
      };
    }
    let rgb = hexToDecimal(c);
    return {
      alpha: false,
      HEX: c,
      HSL: color.hexTohsl(c),
      RGB: {
        r: +rgb[0],
        g: +rgb[1],
        b: +rgb[2],
      },
      FigmaRGBA: {
        r: +rgb[0] / 255,
        g: +rgb[1] / 255,
        b: +rgb[2] / 255,
        a: 0,
      },
    };
  });
}

/* Static methods for ColorSpace convertion
---------------------------------------------*/

class color {
  static getLightness(R, G, B) {
    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    return (max + min) / 2;
  }
  static getSaturation(R, G, B, l) {
    if (R === G && G === B) return 0;

    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    if (l <= 0.5) return (max - min) / (max + min);
    else if (l > 0.5) return (max - min) / (2 - max - min);
  }
  static getHue(R, G, B) {
    if (R === G && G === B) return 0;

    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    let hue;

    if (max === r) hue = (g - b) / (max - min);
    else if (max === g) hue = 2 + (b - r) / (max - min);
    else if (max === b) hue = 4 + (r - g) / (max - min);

    return hue * 60;
  }
  static hexTohsl(str) {
    let rgb = hexToDecimal(str);
    let l = color.getLightness(...rgb);
    let s = color.getSaturation(...rgb, l);
    let h = color.getHue(...rgb);

    if (h < 0) h += 360;

    return {
      h: Math.round(h),
      s: Math.round(s * 100),
      l: Math.round(l * 100),
    };
  }
  static rgbTohsl(...rgb) {
    let l = color.getLightness(...rgb);
    let s = color.getSaturation(...rgb, l);
    let h = color.getHue(...rgb);

    return { h, s, l };
  }
  static rgbaToHexa(str) {
    if (/^rgba/.test(str)) {
      let ary = str.match(/(\d|\.){1,4}/g);
      let hexa = ary.map((h, i) => {
        if (i < 3) return h.toString(16);
        return h * 100;
      });
      return hexa.join('');
    }
    return `${str}00`;
  }
}

let colorObjAry = compose(
  getValuesArray,
  toLowerCase,
  removeDuplicate,
  createColorObj
)(deskvariables);

colorObjAry;

let strObj = JSON.stringify(colorObjAry);

fs.writeFileSync('/Users/mohan-temp/Desktop/color.txt',strObj)
