	let colorObj = JSON.parse(`[{"alpha":false,"HEX":"#0a73eb","HSL":{"h":212,"s":92,"l":48},"RGB":{"r":10,"g":115,"b":235},"FigmaRGBA":{"r":0.0392156862745098,"g":0.45098039215686275,"b":0.9215686274509803,"a":0}},{"alpha":false,"HEX":"#26a942","HSL":{"h":133,"s":63,"l":41},"RGB":{"r":38,"g":169,"b":66},"FigmaRGBA":{"r":0.14901960784313725,"g":0.6627450980392157,"b":0.25882352941176473,"a":0}},{"alpha":false,"HEX":"#de3535","HSL":{"h":0,"s":72,"l":54},"RGB":{"r":222,"g":53,"b":53},"FigmaRGBA":{"r":0.8705882352941177,"g":0.20784313725490197,"b":0.20784313725490197,"a":0}},{"alpha":false,"HEX":"#9a3cee","HSL":{"h":272,"s":84,"l":58},"RGB":{"r":154,"g":60,"b":238},"FigmaRGBA":{"r":0.6039215686274509,"g":0.23529411764705882,"b":0.9333333333333333,"a":0}},{"alpha":false,"HEX":"#7cd917","HSL":{"h":89,"s":81,"l":47},"RGB":{"r":124,"g":217,"b":23},"FigmaRGBA":{"r":0.48627450980392156,"g":0.8509803921568627,"b":0.09019607843137255,"a":0}},{"alpha":false,"HEX":"#f74186","HSL":{"h":337,"s":92,"l":61},"RGB":{"r":247,"g":65,"b":134},"FigmaRGBA":{"r":0.9686274509803922,"g":0.2549019607843137,"b":0.5254901960784314,"a":0}},{"alpha":false,"HEX":"#f6b041","HSL":{"h":37,"s":91,"l":61},"RGB":{"r":246,"g":176,"b":65},"FigmaRGBA":{"r":0.9647058823529412,"g":0.6901960784313725,"b":0.2549019607843137,"a":0}},{"alpha":false,"HEX":"#5ddfee","HSL":{"h":186,"s":81,"l":65},"RGB":{"r":93,"g":223,"b":238},"FigmaRGBA":{"r":0.36470588235294116,"g":0.8745098039215686,"b":0.9333333333333333,"a":0}},{"alpha":false,"HEX":"#ff6f00","HSL":{"h":26,"s":100,"l":50},"RGB":{"r":255,"g":111,"b":0},"FigmaRGBA":{"r":1,"g":0.43529411764705883,"b":0,"a":0}},{"alpha":false,"HEX":"#a9b63f","HSL":{"h":67,"s":49,"l":48},"RGB":{"r":169,"g":182,"b":63},"FigmaRGBA":{"r":0.6627450980392157,"g":0.7137254901960784,"b":0.24705882352941178,"a":0}},{"alpha":false,"HEX":"#001757","HSL":{"h":224,"s":100,"l":17},"RGB":{"r":0,"g":23,"b":87},"FigmaRGBA":{"r":0,"g":0.09019607843137255,"b":0.3411764705882353,"a":0}},{"alpha":false,"HEX":"#2cc990","HSL":{"h":158,"s":64,"l":48},"RGB":{"r":44,"g":201,"b":144},"FigmaRGBA":{"r":0.17254901960784313,"g":0.788235294117647,"b":0.5647058823529412,"a":0}},{"alpha":false,"HEX":"#ee8c3d","HSL":{"h":27,"s":84,"l":59},"RGB":{"r":238,"g":140,"b":61},"FigmaRGBA":{"r":0.9333333333333333,"g":0.5490196078431373,"b":0.23921568627450981,"a":0}},{"alpha":false,"HEX":"#39b4ff","HSL":{"h":203,"s":100,"l":61},"RGB":{"r":57,"g":180,"b":255},"FigmaRGBA":{"r":0.2235294117647059,"g":0.7058823529411765,"b":1,"a":0}},{"alpha":false,"HEX":"#837af2","HSL":{"h":245,"s":82,"l":71},"RGB":{"r":131,"g":122,"b":242},"FigmaRGBA":{"r":0.5137254901960784,"g":0.47843137254901963,"b":0.9490196078431372,"a":0}},{"alpha":false,"HEX":"#ead339","HSL":{"h":52,"s":81,"l":57},"RGB":{"r":234,"g":211,"b":57},"FigmaRGBA":{"r":0.9176470588235294,"g":0.8274509803921568,"b":0.2235294117647059,"a":0}},{"alpha":false,"HEX":"#2cbcc5","HSL":{"h":184,"s":63,"l":47},"RGB":{"r":44,"g":188,"b":197},"FigmaRGBA":{"r":0.17254901960784313,"g":0.7372549019607844,"b":0.7725490196078432,"a":0}},{"alpha":false,"HEX":"#ce9965","HSL":{"h":30,"s":52,"l":60},"RGB":{"r":206,"g":153,"b":101},"FigmaRGBA":{"r":0.807843137254902,"g":0.6,"b":0.396078431372549,"a":0}},{"alpha":false,"HEX":"#5d5fb3","HSL":{"h":239,"s":36,"l":53},"RGB":{"r":93,"g":95,"b":179},"FigmaRGBA":{"r":0.36470588235294116,"g":0.37254901960784315,"b":0.7019607843137254,"a":0}},{"alpha":false,"HEX":"#188c8b","HSL":{"h":179,"s":71,"l":32},"RGB":{"r":24,"g":140,"b":139},"FigmaRGBA":{"r":0.09411764705882353,"g":0.5490196078431373,"b":0.5450980392156862,"a":0}},{"alpha":false,"HEX":"#d43b99","HSL":{"h":323,"s":64,"l":53},"RGB":{"r":212,"g":59,"b":153},"FigmaRGBA":{"r":0.8313725490196079,"g":0.23137254901960785,"b":0.6,"a":0}},{"alpha":false,"HEX":"#cfcb51","HSL":{"h":58,"s":57,"l":56},"RGB":{"r":207,"g":203,"b":81},"FigmaRGBA":{"r":0.8117647058823529,"g":0.796078431372549,"b":0.3176470588235294,"a":0}},{"alpha":false,"HEX":"#df5f37","HSL":{"h":14,"s":72,"l":55},"RGB":{"r":223,"g":95,"b":55},"FigmaRGBA":{"r":0.8745098039215686,"g":0.37254901960784315,"b":0.21568627450980393,"a":0}},{"alpha":false,"HEX":"#56ca4e","HSL":{"h":116,"s":54,"l":55},"RGB":{"r":86,"g":202,"b":78},"FigmaRGBA":{"r":0.33725490196078434,"g":0.792156862745098,"b":0.3058823529411765,"a":0}},{"alpha":false,"HEX":"#b353cb","HSL":{"h":288,"s":54,"l":56},"RGB":{"r":179,"g":83,"b":203},"FigmaRGBA":{"r":0.7019607843137254,"g":0.3254901960784314,"b":0.796078431372549,"a":0}},{"alpha":false,"HEX":"#8b1650","HSL":{"h":330,"s":73,"l":32},"RGB":{"r":139,"g":22,"b":80},"FigmaRGBA":{"r":0.5450980392156862,"g":0.08627450980392157,"b":0.3137254901960784,"a":0}},{"alpha":false,"HEX":"#8dcbac","HSL":{"h":150,"s":37,"l":67},"RGB":{"r":141,"g":203,"b":172},"FigmaRGBA":{"r":0.5529411764705883,"g":0.796078431372549,"b":0.6745098039215687,"a":0}},{"alpha":false,"HEX":"#00468b","HSL":{"h":210,"s":100,"l":27},"RGB":{"r":0,"g":70,"b":139},"FigmaRGBA":{"r":0,"g":0.27450980392156865,"b":0.5450980392156862,"a":0}},{"alpha":false,"HEX":"#003d00","HSL":{"h":120,"s":100,"l":12},"RGB":{"r":0,"g":61,"b":0},"FigmaRGBA":{"r":0,"g":0.23921568627450981,"b":0,"a":0}},{"alpha":false,"HEX":"#93b728","HSL":{"h":75,"s":64,"l":44},"RGB":{"r":147,"g":183,"b":40},"FigmaRGBA":{"r":0.5764705882352941,"g":0.7176470588235294,"b":0.1568627450980392,"a":0}}]`);

	const compose = (...fn) => (arg) => fn.reduce((a, e) => e(a), arg);

	const filter = (min: number, max: number) => ary => ary.filter(c => c.HSL.h >= min && c.HSL.h <= max);

	function sortByLightness(ary) {
		return ary.sort((a, b) => {
			const m = a.HSL.l,
				n = b.HSL.l;
			if (m === n) return 0;
			else return m > n ? -1 : 1;
		});
	}
	function sortByOpacity(ary) {
		return ary.sort((a, b) => {
			const m = a.HSLA.a;
			const n = b.HSLA.a;
			if (m === n) return 0;
			else return m > n ? 1 : -1;
		});
	}

	const accent = colorObj.filter((c) => c.HSL.s >= 50 && c.alpha === false);
	const grey = colorObj.filter((c) => c.HSL.s < 50 && c.alpha === false);
	const accentOpace = colorObj.filter((c) => c.alpha === true && c.HSL.s >= 50);
	const greyOpace = colorObj.filter((c) => c.alpha === true && c.HSL.s < 50);

	const renderObj = (min, max) => {
		return {
			minHue: min,
			maxHue: max,
			accent: compose(filter(min, max), sortByLightness)(accent),
			grey: compose(filter(min, max), sortByLightness)(grey),
			accentOpace: compose(filter(min, max), sortByOpacity)(accentOpace),
			greyOpace: compose(filter(min, max), sortByOpacity)(greyOpace)
		}
	}

	function getTile(c, i) {
		return <Frame x={(i % 10) * 150} y={Math.floor(i / 10) * 150} width={100} height={90} fills={[]} >
			<Rectangle
				height={40}
				cornerRadius={3}
				fills={[RGBA(c.FigmaRGBA.r, c.FigmaRGBA.g, c.FigmaRGBA.b, c.FigmaRGBA.a).paint]}
			/>
			<Text
				characters={`${c.HSL.h}   ${c.HSL.s}   ${c.HSL.l}   ${c.FigmaRGBA.a}`}
				x={0}
				y={52}
				fontSize={12}
			/>

			<Text
				characters={`${c.HEX}`}
				x={0}
				y={75}
				fontSize={10}
				textCase="UPPER"
				letterSpacing={{ value: 0.8, unit: 'PIXELS' }}
				fills={[RGBA(0, 0, 0, .25).paint]}
			/>
		</Frame>;
	}
	function getOpaceTile(c, i) {
		return <Frame x={(i % 10) * 150} y={Math.floor(i / 10) * 150} width={100} height={90} fills={[]} >
			<Rectangle
				height={40}
				cornerRadius={3}
				fills={[RGB(c.FigmaRGBA.r, c.FigmaRGBA.g, c.FigmaRGBA.b).paint]}
			/>
			<Text
				characters={`${c.HSL.h}   ${c.HSL.s}   ${c.HSL.l}`}
				x={0}
				y={52}
				fontSize={12}
			/>

			<Text
				characters={`${c.HEX}`}
				x={0}
				y={75}
				fontSize={10}
				textCase="UPPER"
				letterSpacing={{ value: 0.8, unit: 'PIXELS' }}
				fills={[RGBA(0, 0, 0, .25).paint]}
			/>
		</Frame>;
	}

	renderObj(0,360)['accent'].forEach((c,i)=>{
	{c.alpha === true ? addToPage(getTile(c,i)): addToPage(getOpaceTile(c,i)) }
	})

