const hexToDecimal =(...hex) =>{
  let dec = [];
  hex.forEach((h) => {
    dec.push(parseInt(h, 16));
  });
  return dec;
}
const getLightness = (R, G, B) => {
  const r = R / 255,
    g = G / 255,
    b = B / 255;

  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);

  return (max + min) / 2;
};
const getSaturation = (R, G, B, l) => {
  if (R === G && G === B) return 0;

  const r = R / 255,
    g = G / 255,
    b = B / 255;

  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);

  if (l <= 0.5) return (max - min) / (max + min);
  else if (l > 0.5) return (max - min) / (2 - max - min);
};
function getHue(R, G, B) {
  if (R === G && G === B) return 0;
  
  const r = R / 255,
    g = G / 255,
    b = B / 255;

  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  
  let hue;

  if (max === r) hue = (g - b) / (max - min);
  else if (max === g) hue = 2 + (b - r) / (max - min);
  else if (max === b) hue = 4 + (r - g) / (max - min);
  
  return hue*60;
}
function hex2hsl(str) {
  let rgb = hexToDecimal(str.slice(1, 3), str.slice(3, 5), str.slice(5));
  console.log(`rgb: ${rgb}`)
  let l = getLightness(...rgb);
  let s = getSaturation(...rgb, l);
  let h = getHue(...rgb);

  return `h: ${h}, s: ${s}, l: ${l}`;
}


hex2hsl('#444a61');
hex2hsl('#42485f');
hex2hsl('#42465f');