/* General Utility Functions
-----------------------------------*/

function $(a, b = document) {
  return b.querySelector(a);
}
function $all(a, b = document) {
  return [...b.querySelectorAll(a)];
}
function rand(min, max) {
  return Math.floor(Math.random() * (max - min + 1) + min);
}
function applyStyle(el, style) {
  Object.assign(el.style, style);
}
const compose = (...fn) => (arg) => fn.reduce((a, e) => e(a), arg);

/*  Utility Functions
----------------------------*/

function getHexArray(str) {
  let hex = str.trim().toLowerCase().replace(/^#/, "");
  hex = hex.length === 3 ? `${hex}${hex}` : hex;
  const result = hex.match(/(\d|[a-f]){2}/g);
  if (!result || result.length !== 3) throw new Error("Invalid Hex String");
  return result;
}
function hexToDecimal(ary) {
  let hex = ary;
  if (!Array.isArray(ary)) hex = getHexArray(hex);
  return hex.map((c) => parseInt(c, 16));
}
function removeDuplicate(ary) {
  return [...new Set(ary)];
}
function getValuesArray(obj) {
  return Object.values(obj);
}
function toLowerCase(ary) {
  return ary.map((el) => el.toLowerCase());
}

const render = (minHex, maxHex) => (ary = colorObjAry) => {
  const colors = ary.filter((c) => c.hsl.h >= minHex && c.hsl.h <= maxHex);
  const accent = colors.filter((c) => c.hsl.s >= 50 && c.alpha === false);
  const grey = colors.filter((c) => c.hsl.s < 50 && c.alpha === false);
  const accentOpace = colors.filter((c) => c.alpha === true && c.hsl.s >= 50);
  const greyOpace = colors.filter((c) => c.alpha === true && c.hsl.s < 50);

  sortByLightness(accent);
  sortByLightness(grey);
  sortByOpacity(accentOpace);
  sortByOpacity(greyOpace);

  function sortByLightness(ary) {
    ary.sort((a, b) => {
      const m = a.hsl.l,
        n = b.hsl.l;
      if (m === n) return 0;
      else return m > n ? -1 : 1;
    });
  }
  function sortByOpacity(ary) {
    ary.sort((a, b) => {
      const m = a.hsla.a,
        n = b.hsla.a;
      if (m === n) return 0;
      else return m > n ? 1 : -1;
    });
  }
  function getTile({ hsl, hex }) {
    return `
      <div class="tile" style="background-color: ${hex}">
          <div class="specs"><div class="hsl">
          ${hsl.h} &nbsp;${hsl.s} &nbsp;${hsl.l}
    </div>
    <div class="hex">${hex.toUpperCase()}</div></div>
      </div>`;
  }
  function getOpaceTile({ hsla, hex, rgba }) {
    return `
      <div class="tile" style="background-color: rgba(${rgba})">
          <div class="specs"><div class="hsl">
          ${hsla.h} &nbsp;${hsla.s} &nbsp;${hsla.l} &nbsp;${hsla.a}
    </div>
    <div class="hex">${hex.toUpperCase()}</div></div>
      </div>`;
  }

  let sec = document.createElement("section");
  sec.innerHTML = `
    <header class="sep1 h1">Hue ${minHex}° – ${maxHex}°</header>
    <div>
        <p class="h2">Accent (${accent.length})</p>
        <section class="grid accent">
            ${accent.map((hex) => getTile(hex)).join("")}
        </section>
    </div>
    <div>
    <p class="h2">Accent-Opace (${accentOpace.length})</p>
        <section class="grid grey">
            ${accentOpace.map((hex) => getOpaceTile(hex)).join("")}
        </section>
    </div>
    <p class="h2">Grey (${grey.length})</p>
        <section class="grid grey">
            ${grey.map((hex) => getTile(hex)).join("")}
        </section>
    </div>
    <div>
    <p class="h2">Grey-Opace (${greyOpace.length})</p>
        <section class="grid grey">
            ${greyOpace.map((hex) => getOpaceTile(hex)).join("")}
        </section>
    </div>
    <div>
    
    `;
  $("main").appendChild(sec);
};

function createColorObj(ary) {
  return ary.map((c) => {
    if (/^rgba/.test(c)) {
      let rgba = c.match(/(\d|\.){1,4}/g);
      let hexa = rgba.map((h, i) => {
        if (i < 3) {
          let x = `0${parseInt(h).toString(16)}`.slice(-2);
          return x;
        }
        return Math.round(h * 100);
      });
      let hex = `#${hexa.slice(0, 3).join("")}`;
      let hsl = color.hexTohsl(hex);
      return {
        alpha: true,
        hex,
        hsl,
        hsla: { ...hsl, a: hexa[3] },
        rgb: `${rgba.slice(0, 3).join(",")}`,
        rgba: `${rgba.join(",")}`,
      };
    } else
      return {
        alpha: false,
        hex: c,
        hsl: color.hexTohsl(c),
        rgb: hexToDecimal(c),
      };
  });
}

/* Static methods for ColorSpace convertion
---------------------------------------------*/

class color {
  static getLightness(R, G, B) {
    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    return (max + min) / 2;
  }
  static getSaturation(R, G, B, l) {
    if (R === G && G === B) return 0;

    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    if (l <= 0.5) return (max - min) / (max + min);
    else if (l > 0.5) return (max - min) / (2 - max - min);
  }
  static getHue(R, G, B) {
    if (R === G && G === B) return 0;

    const r = R / 255,
      g = G / 255,
      b = B / 255;

    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);

    let hue;

    if (max === r) hue = (g - b) / (max - min);
    else if (max === g) hue = 2 + (b - r) / (max - min);
    else if (max === b) hue = 4 + (r - g) / (max - min);

    return hue * 60;
  }
  static hexTohsl(str) {
    let rgb = hexToDecimal(str);
    let l = color.getLightness(...rgb);
    let s = color.getSaturation(...rgb, l);
    let h = color.getHue(...rgb);

    if (h < 0) h += 360;

    return {
      h: Math.round(h),
      s: Math.round(s * 100),
      l: Math.round(l * 100),
    };
  }
  static rgbTohsl(...rgb) {
    let l = color.getLightness(...rgb);
    let s = color.getSaturation(...rgb, l);
    let h = color.getHue(...rgb);

    return { h, s, l };
  }
  static rgbaToHexa(str) {
    if (/^rgba/.test(str)) {
      let ary = str.match(/(\d|\.){1,4}/g);
      let hexa = ary.map((h, i) => {
        if (i < 3) return h.toString(16);
        return h * 100;
      });
      return hexa.join("");
    }
    return `${str}00`;
  }
}

let colorObjAry = compose(
  getValuesArray,
  toLowerCase,
  removeDuplicate,
  createColorObj
)(deskvariables);

/* Rendering Colors to DOM
---------------------*/
for (i = 0; i < 360; i += 40) {
  render(i, i + 40)();
}
